/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.tablet;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import jfxtras.labs.internal.scene.control.skin.BigDecimalFieldSkin;
import jfxtras.labs.scene.control.BigDecimalField;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletUtils {
    private static final Logger log = LoggerFactory.getLogger(TabletUtils.class);

    public static void configureNumericKeyboard(TextField ... fields) {
        for (TextField field : fields) {
            field.getProperties().put((Object)"vkType", (Object)"numeric");
        }
    }

    public static void configureNumericKeyboard(BigDecimalField ... fields) {
        for (final BigDecimalField bdf : fields) {
            bdf.skinProperty().addListener(new ChangeListener<Skin<?>>(){

                public void changed(ObservableValue<? extends Skin<?>> observable, Skin<?> oldValue, Skin<?> newValue) {
                    try {
                        BigDecimalFieldSkin skin = (BigDecimalFieldSkin)bdf.getSkin();
                        TextField tf = (TextField)FieldUtils.readDeclaredField((Object)skin, (String)"textField", (boolean)true);
                        tf.getProperties().put((Object)"vkType", (Object)"numeric");
                    }
                    catch (Exception e) {
                        log.warn("Couldn't set numeric keyboard", (Throwable)e);
                    }
                }
            });
        }
    }
}

