/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.table;

import com.anahata.jfx.bind.Bind;
import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.BindModel;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.Binding;
import com.anahata.jfx.bind.BindingController;
import com.anahata.jfx.bind.View;
import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.table.BindTableColumn;
import com.anahata.jfx.bind.table.BindingTableView;
import com.anahata.util.metamodel.MetaModelProperty;
import com.anahata.util.metamodel.MetaModelUtils;
import com.anahata.util.reflect.AnahataPropertyUtils;
import com.anahata.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableRow;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BindingTableRow<T>
extends TableRow<T>
implements BindForm {
    private static final Logger log = LoggerFactory.getLogger(BindingTableRow.class);
    @Inject
    private Binder binder;
    private final BooleanProperty formValid = new SimpleBooleanProperty(true);
    private final BooleanProperty formModified = new SimpleBooleanProperty(false);
    private final BooleanProperty hasValue = new SimpleBooleanProperty(false);
    private final Map<String, Object> targets = new HashMap<String, Object>();
    private final Map<String, Class> propertyTypes = new HashMap<String, Class>();
    private final Map<String, String> columnFields = new HashMap<String, String>();
    private final Map<String, Bind> columnIds = new HashMap<String, Bind>();
    private final Map<Class<?>, BooleanProperty> valids = new HashMap();
    private final Map<String, String> styleClasses = new HashMap<String, String>();
    private BindingTableView bindingTableView;
    @BindModel(autoBind=false)
    private final ObjectProperty<T> model = new SimpleObjectProperty();
    private final BooleanProperty readOnly = new SimpleBooleanProperty();

    @PostConstruct
    public void initBindingTableRow() {
        log.debug("initBindingTableRow: ENTERING");
        this.preInit();
        this.binder.init(this);
        this.formValid.bind((ObservableValue)this.binder.formValidProperty().or((ObservableBooleanValue)this.hasValue.not()));
        this.formModified.bind((ObservableValue)this.binder.formModifiedProperty().and((ObservableBooleanValue)this.hasValue));
        List fields = ReflectionUtils.getAllDeclaredFields(this.getClass());
        for (Field field : fields) {
            BindTableColumn column = field.getAnnotation(BindTableColumn.class);
            if (column == null) continue;
            String id = column.id();
            if (StringUtils.isEmpty((CharSequence)id)) {
                log.debug("@BindTableColumn annotation without id on {}.{} field name will be used as column id", (Object)this.getClass().getName(), (Object)field.getName());
                id = field.getName();
            }
            Object target = ReflectionUtils.readField((Object)this, Object.class, (Field)field);
            this.targets.put(id, target);
            Bind bind = field.getAnnotation(Bind.class);
            if (bind != null) {
                MetaModelProperty[] mmFields = new MetaModelProperty[bind.property().length];
                for (int j = 0; j < bind.property().length; ++j) {
                    mmFields[j] = (MetaModelProperty)ReflectionUtils.getInstance(bind.property()[j], (Object[])new Object[0]);
                }
                String path = MetaModelUtils.getNestedPropertyName((MetaModelProperty[])mmFields);
                this.columnFields.put(id, path);
                log.debug("initBindingTableRow: Mapping column id {} to bind id {}", (Object)column.id(), (Object)bind.id());
                this.columnIds.put(id, bind);
                this.propertyTypes.put(id, mmFields[0].getType());
            }
            if (target instanceof Node) {
                Node node = (Node)target;
                node.disableProperty().bind((ObservableValue)this.readOnly);
            }
            if (StringUtils.isBlank((CharSequence)column.styleClass())) continue;
            this.styleClasses.put(id, column.styleClass());
        }
        this.postInit();
    }

    @Override
    public Binder getRootBinder() {
        return this.binder.getRootBinder();
    }

    @Override
    public void setRootBinder(Binder binder) {
        this.binder.setRootBinder(binder);
    }

    @Override
    public BindForm getParentBindForm() {
        return this.binder.getParentBindForm();
    }

    @Override
    public void setParentBindForm(BindForm parentBindForm) {
        this.binder.setParentBindForm(parentBindForm);
    }

    @Override
    public Binding getParentBinding() {
        return this.binder.getParentBinding();
    }

    @Override
    public void setParentBinding(Binding parentBinding) {
        this.binder.setParentBinding(parentBinding);
    }

    @Override
    public View getView(Binding binding) {
        return this.binder.getView(binding);
    }

    @Override
    public void setView(View view, Binding binding) {
        this.binder.setView(view, binding);
    }

    @Override
    public void resetFormModified() {
        this.binder.resetFormModified();
    }

    @Override
    public void bindFromModel() {
        if (this.isHasValue()) {
            this.binder.bindFromModel();
            this.postBindFromModel(new Object[0]);
        }
    }

    @Override
    public void bindFromModelExcludingNode(Object node) {
        if (this.isHasValue()) {
            this.binder.bindFromModelExcludingNode(node);
            this.postBindFromModel(node);
        }
    }

    @Override
    public void validate(boolean publishError, Object ... excludeNodes) {
        if (this.isHasValue()) {
            this.binder.validate(publishError, excludeNodes);
        }
    }

    @Override
    public Map<Node, Binding> getAllNodeBindings() {
        if (this.isHasValue()) {
            return this.binder.getAllNodeBindings();
        }
        return Collections.emptyMap();
    }

    @Override
    public BooleanProperty formValidProperty() {
        return this.formValid;
    }

    @Override
    public BooleanProperty formModifiedProperty() {
        return this.formModified;
    }

    @Override
    public BooleanProperty showContainerErrors() {
        return this.binder.showContainerErrors();
    }

    @Override
    public void setExcludeNodes(Object ... nodes) {
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        this.binder.addValidationGroup(validationGroup);
        if (!this.valids.containsKey(validationGroup)) {
            SimpleBooleanProperty valid = new SimpleBooleanProperty(true);
            this.valids.put(validationGroup, (BooleanProperty)valid);
            valid.bind((ObservableValue)this.binder.getFormValidProperty(validationGroup).or((ObservableBooleanValue)this.hasValue.not()));
        }
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        this.binder.removeValidationGroup(validationGroup);
        if (this.valids.containsKey(validationGroup)) {
            this.valids.get(validationGroup).unbind();
            this.valids.remove(validationGroup);
        }
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        return this.binder.getValidationActive(validationGroup);
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        Validate.notNull(validationGroup);
        Validate.validState((boolean)this.valids.containsKey(validationGroup), (String)"The validation group %s has not been set in this class", (Object[])new Object[]{validationGroup.getSimpleName()});
        return (ReadOnlyBooleanProperty)this.valids.get(validationGroup);
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        this.binder.setValid(propertyName, validationGroup);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        this.binder.setInvalid(propertyName, validationGroup);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.binder.getValidations();
    }

    public boolean isHasValue() {
        return this.hasValue.get();
    }

    public final Object getTarget(String columnId) {
        return this.targets.get(columnId);
    }

    public final String getStyleClass(String columnId) {
        return this.styleClasses.get(columnId);
    }

    public final Object getModelValue(String columnId) {
        try {
            Bind bind = this.columnIds.get(columnId);
            Object value = this.getRawModelValue(columnId);
            if (value != null) {
                Converter converter;
                try {
                    converter = (Converter)ReflectionUtils.getInstanceIfNotBase(Converter.class, bind.converter(), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    converter = (Converter)ReflectionUtils.getInstanceIfNotBase(Converter.class, bind.converter(), (Object[])new Object[]{this});
                }
                if (converter != null) {
                    value = converter.getAsNodeModelValue(null, value);
                }
            }
            return value;
        }
        catch (NestedNullException e) {
            return null;
        }
    }

    public final Object getRawModelValue(String columnId) {
        try {
            Bind bind = this.columnIds.get(columnId);
            if (bind == null) {
                return null;
            }
            Object target = this.binder.getTargetBean(bind.id());
            Object value = this.isInContext(columnId, target) ? AnahataPropertyUtils.getProperty((Object)target, (String)this.columnFields.get(columnId)) : null;
            return value;
        }
        catch (NestedNullException e) {
            return null;
        }
    }

    public final ObjectProperty<T> modelProperty() {
        return this.model;
    }

    public final T getModel() {
        return (T)this.modelProperty().getValue();
    }

    public boolean isReadOnly() {
        return this.readOnly.get();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly.set(readOnly);
    }

    public BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    @Override
    public void setValidationRequired() {
        this.binder.setValidationRequired();
    }

    final Set<String> getColumnIds() {
        return this.targets.keySet();
    }

    void setHasValue(boolean hasValue) {
        this.hasValue.set(hasValue);
    }

    protected final void updateItem(T item, boolean empty) {
        boolean changed = item != super.getItem();
        super.updateItem(item, empty);
        this.hasValue.set(item != null && !empty);
        if (this.hasValue.get()) {
            this.modelProperty().setValue(item);
            if (changed) {
                this.getBinder().bindFromModel(false);
            }
        } else {
            this.modelProperty().setValue(null);
        }
        this.updateItem();
    }

    protected <C extends BindingController> C getParentController() {
        Binder parentBinder = (Binder)this.getBindingTableView().getParentBindForm();
        return (C)((BindingController)parentBinder.getController());
    }

    protected void updateItem() {
    }

    protected void preInit() {
    }

    protected void postInit() {
    }

    protected void postBindFromModel(Object ... excludeNodes) {
    }

    private boolean isInContext(String columId, Object target) {
        Bind bind = this.columnIds.get(columId);
        Class<? extends MetaModelProperty>[] path = bind.property();
        Class<? extends MetaModelProperty> metamodelClass = path[0];
        MetaModelProperty instance = (MetaModelProperty)ReflectionUtils.getInstance(metamodelClass, (Object[])new Object[0]);
        Class declaringClass = instance.getDeclaringClass();
        return target != null ? declaringClass.isAssignableFrom(target.getClass()) : false;
    }

    protected Binder getBinder() {
        return this.binder;
    }

    protected BindingTableView getBindingTableView() {
        return this.bindingTableView;
    }

    void setBindingTableView(BindingTableView bindingTableView) {
        this.bindingTableView = bindingTableView;
    }
}

