/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.bind.table.BindingTableViewUtils;
import com.anahata.jfx.scene.control.CalendarTextField;
import com.anahata.util.lang.builder.HashMapBuilder;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import lombok.NonNull;

public class ReadOnlyUtils {
    private static final Map<Class, String> STYLECLASSES = new HashMapBuilder().add(TextField.class, (Object)"read-only-text-input").add(Label.class, (Object)"read-only-label").add(ComboBox.class, (Object)"read-only-combo-box").add(CheckBox.class, (Object)"read-only-check-box").add(TableView.class, (Object)"read-only-table-view").add(CalendarTextField.class, (Object)"read-only-calendar").build();

    public static String getStyleClass(@NonNull Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return STYLECLASSES.get(clazz);
    }

    public static String getStyleClass(@NonNull Object node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        return ReadOnlyUtils.getStyleClass(node.getClass());
    }

    public static void bindReadOnlyStyleClass(@NonNull ObservableValue<? extends Boolean> readOnly, Object ... nodes) {
        if (readOnly == null) {
            throw new NullPointerException("readOnly");
        }
        if (nodes == null) {
            throw new NullPointerException("nodes");
        }
        for (Object node : nodes) {
            if (!(node instanceof Node)) continue;
            JfxUtils.bindStyleClass((Node)node, readOnly, ReadOnlyUtils.getStyleClass(node.getClass()), null);
        }
    }

    public static void bindReadOnly(@NonNull ObservableValue<? extends Boolean> readOnly, Object ... nodes) {
        if (readOnly == null) {
            throw new NullPointerException("readOnly");
        }
        if (nodes == null) {
            throw new NullPointerException("nodes");
        }
        for (Object nodeObj : nodes) {
            if (nodeObj instanceof TableView) {
                TableView tv = (TableView)nodeObj;
                JfxUtils.bindStyleClass((Node)tv, readOnly, ReadOnlyUtils.getStyleClass(tv), null);
                BindingTableViewUtils.bindReadOnly(readOnly, tv);
                continue;
            }
            if (nodeObj instanceof Node) {
                Node node = (Node)nodeObj;
                JfxUtils.bindStyleClass(node, readOnly, ReadOnlyUtils.getStyleClass(node), null);
                node.disableProperty().bind(readOnly);
                continue;
            }
            if (nodeObj instanceof Tab) {
                Tab tab = (Tab)nodeObj;
                JfxUtils.bindStyleClass(tab, readOnly, ReadOnlyUtils.getStyleClass(tab), null);
                tab.disableProperty().bind(readOnly);
                continue;
            }
            throw new IllegalArgumentException("Unknown node type: " + nodeObj.getClass().getName());
        }
    }

    public static void bindReadOnlyList(@NonNull ObservableValue<? extends Boolean> readOnly, @NonNull List<? extends Object> nodes) {
        if (readOnly == null) {
            throw new NullPointerException("readOnly");
        }
        if (nodes == null) {
            throw new NullPointerException("nodes");
        }
        ReadOnlyUtils.bindReadOnly(readOnly, nodes.toArray());
    }

    private ReadOnlyUtils() {
    }
}

