/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import org.lodgon.openmapfx.core.DefaultBaseMapProvider;
import org.lodgon.openmapfx.core.LayeredMap;
import org.lodgon.openmapfx.core.MapLayer;
import org.lodgon.openmapfx.desktop.SimpleProviderPicker;
import org.lodgon.openmapfx.layer.LicenceLayer;
import org.lodgon.openmapfx.layer.RectangleLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapView
extends BorderPane {
    private static final Logger log = LoggerFactory.getLogger(MapView.class);
    private LayeredMap map;
    private SimpleProviderPicker providerPicker;
    private DefaultBaseMapProvider defaultBaseMapProvider;
    private LicenceLayer licenceLayer;
    private Callback<String, Void> onOverlaySelect;
    private Callback<String, Void> onOverlayDeselect;

    public MapView() {
        try {
            this.initialize();
        }
        catch (Exception ex) {
            log.error("Exception in initializing MapView ", (Throwable)ex);
        }
    }

    protected void initialize() throws Exception {
        this.defaultBaseMapProvider = new DefaultBaseMapProvider();
        this.providerPicker = new SimpleProviderPicker(this.defaultBaseMapProvider);
        this.map = new LayeredMap(this.defaultBaseMapProvider);
        BorderPane cbp = new BorderPane();
        cbp.setCenter((Node)this.map);
        this.map.install((Region)cbp);
        Rectangle clip = new Rectangle(700.0, 600.0);
        cbp.setClip((Node)clip);
        clip.heightProperty().bind((ObservableValue)cbp.heightProperty());
        clip.widthProperty().bind((ObservableValue)cbp.widthProperty());
        this.setTop((Node)this.providerPicker);
        this.setCenter((Node)cbp);
        this.map.setZoom(8.0);
        this.setPerthAsCenter();
        this.licenceLayer = new LicenceLayer(this.defaultBaseMapProvider);
        this.map.getLayers().add((Object)this.licenceLayer);
    }

    public void setPerthAsCenter() {
        this.map.setCenter(-31.957023, 115.861189);
    }

    public void addRectangleOverlay(String text, double[] nw, double[] se) {
        this.addRectangleOverlay(text, nw, se, false);
    }

    public void addRectangleOverlay(String text, double[] nw, double[] se, boolean nonUBD) {
        RectangleLayer positionLayer = new RectangleLayer(text);
        positionLayer.setId("overlay-" + text);
        positionLayer.setNonUBD(nonUBD);
        positionLayer.setOnOverlaySelect(this.onOverlaySelect);
        positionLayer.setOnOverlayDeselect(this.onOverlayDeselect);
        this.map.getLayers().add((Object)positionLayer);
        positionLayer.updatePosition(nw[0], nw[1], se[0], se[1]);
        if (nonUBD) {
            positionLayer.setOverlayColor("#888888");
        }
    }

    public void removeAllOverlays() {
        ArrayList<MapLayer> overlays = new ArrayList<MapLayer>();
        for (MapLayer layer : this.map.getLayers()) {
            if (!(layer instanceof RectangleLayer)) continue;
            overlays.add(layer);
        }
        this.map.getLayers().removeAll(overlays);
    }

    public void removeOverlay(String number) {
        String id = "overlay-" + number;
        Iterator iterator = this.map.getLayers().iterator();
        while (iterator.hasNext()) {
            MapLayer next = (MapLayer)iterator.next();
            if (!(next instanceof RectangleLayer) || !id.equals(((RectangleLayer)next).getId())) continue;
            iterator.remove();
            break;
        }
    }

    public void selectOverlay(String number, String color) {
        String id = "overlay-" + number;
        for (MapLayer next : this.map.getLayers()) {
            if (!(next instanceof RectangleLayer) || !id.equals(((RectangleLayer)next).getId())) continue;
            ((RectangleLayer)next).setOverlayColor(color);
            break;
        }
    }

    public void deselectAllOverlays() {
        for (MapLayer layer : this.map.getLayers()) {
            if (!(layer instanceof RectangleLayer)) continue;
            ((RectangleLayer)layer).setOverlayColor(null);
        }
    }

    public void deselectOverlay(String number) {
        String id = "overlay-" + number;
        for (MapLayer layer : this.map.getLayers()) {
            if (!(layer instanceof RectangleLayer) || !id.equals(((RectangleLayer)layer).getId())) continue;
            ((RectangleLayer)layer).setOverlayColor(null);
            break;
        }
    }

    public LayeredMap getMap() {
        return this.map;
    }

    public SimpleProviderPicker getProviderPicker() {
        return this.providerPicker;
    }

    public DefaultBaseMapProvider getDefaultBaseMapProvider() {
        return this.defaultBaseMapProvider;
    }

    public LicenceLayer getLicenceLayer() {
        return this.licenceLayer;
    }

    public Callback<String, Void> getOnOverlaySelect() {
        return this.onOverlaySelect;
    }

    public void setOnOverlaySelect(Callback<String, Void> onOverlaySelect) {
        this.onOverlaySelect = onOverlaySelect;
    }

    public Callback<String, Void> getOnOverlayDeselect() {
        return this.onOverlayDeselect;
    }

    public void setOnOverlayDeselect(Callback<String, Void> onOverlayDeselect) {
        this.onOverlayDeselect = onOverlayDeselect;
    }
}

