/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import org.apache.commons.compress.utils.IOUtils;
import org.lodgon.openmapfx.core.MapArea;
import org.lodgon.openmapfx.core.MapTileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTile
extends Region {
    private static final Logger log = LoggerFactory.getLogger(MapTile.class);
    private final MapArea mapArea;
    private final MapTileType tileType;
    private final int myZoom;
    private final long i;
    private final long j;
    private final List<MapTile> covering = new LinkedList<MapTile>();
    private boolean debug = false;
    private Label debugLabel = new Label();
    static AtomicInteger createcnt = new AtomicInteger(0);
    final Scale scale = new Scale();
    private final InvalidationListener zl;
    private InvalidationListener ipl;
    private final BooleanProperty loading = new SimpleBooleanProperty(true);
    private final MapTile parentTile;
    private Image image;
    private ImageView imageView;
    private static final List<MapTile> loadQueue = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadNow() {
        if (this.image != null) {
            return;
        }
        List<MapTile> list = loadQueue;
        synchronized (list) {
            log.debug("requeing " + (Object)((Object)this));
            if (loadQueue.contains((Object)this)) {
                loadQueue.remove((Object)this);
                loadQueue.add(0, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapTile(MapArea mapArea, MapTileType tileType, int zoom, long i, long j) {
        int ig = createcnt.incrementAndGet();
        if (this.debug) {
            System.out.println("Create tile #" + ig);
        }
        this.mapArea = mapArea;
        this.tileType = tileType;
        this.myZoom = zoom;
        this.i = i;
        this.j = j;
        this.scale.setPivotX(0.0);
        this.scale.setPivotY(0.0);
        this.getTransforms().add((Object)this.scale);
        this.imageView = new ImageView();
        List<MapTile> list = loadQueue;
        synchronized (list) {
            loadQueue.add(0, this);
            loadQueue.notify();
            log.debug("Added tile to queue, current size {}", (Object)loadQueue.size());
        }
        this.debugLabel.setText("Loading [z=" + zoom + " i=" + i + " j=" + j + "]");
        this.getChildren().addAll((Object[])new Node[]{this.imageView, this.debugLabel});
        this.parentTile = mapArea.findCovering(zoom, i, j);
        if (this.parentTile != null) {
            if (this.debug) {
                System.out.println("[JVDBG] ASK " + (Object)((Object)this.parentTile) + " to cover for " + (Object)((Object)this));
            }
            this.parentTile.addCovering(this);
        }
        this.zl = this.recalculate();
        mapArea.zoomProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.zl));
        mapArea.translateXProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.zl));
        mapArea.translateYProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.zl));
        this.calculatePosition();
    }

    private void download() throws Exception {
        long ts = System.currentTimeMillis();
        InputStream is = this.tileType.getInputStream(this.myZoom, this.i, this.j);
        log.debug("Got tile input stream in " + (System.currentTimeMillis() - ts) + " ms.");
        byte[] barr = IOUtils.toByteArray((InputStream)is);
        log.info("Downloaded tile in " + (System.currentTimeMillis() - ts));
        Platform.runLater(() -> this.gotImage(barr));
    }

    private void gotImage(byte[] barr) {
        this.debugLabel.setText("");
        this.image = new Image((InputStream)new ByteArrayInputStream(barr));
        this.imageView.setImage(this.image);
        this.loading.bind((ObservableValue)this.image.progressProperty().lessThan(1.0));
        this.ipl = this.createImageProgressListener();
        this.image.progressProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.ipl));
        this.ipl.invalidated((Observable)this.loading);
    }

    public int getZoomLevel() {
        return this.myZoom;
    }

    public boolean loading() {
        return this.loading.get();
    }

    public void addCovering(MapTile me) {
        this.covering.add(me);
        this.setVisible(true);
    }

    public void removeCovering(MapTile me) {
        this.covering.remove((Object)me);
        this.calculatePosition();
    }

    public MapTile getCoveringTile() {
        return this.parentTile;
    }

    public boolean isCovering() {
        return this.covering.size() > 0;
    }

    public String toString() {
        return "Tile[" + this.myZoom + "]" + " " + this.i + ", " + this.j + " " + this.tileType.getTypeName();
    }

    private InvalidationListener recalculate() {
        return o -> this.calculatePosition();
    }

    private InvalidationListener createImageProgressListener() {
        InvalidationListener answer = o -> {
            double progress = this.image.getProgress();
            if (progress >= 1.0 && this.parentTile != null) {
                if (this.debug) {
                    System.out.println("[JVDBG] ASK " + (Object)((Object)this.parentTile) + " to FORGET cover for " + (Object)((Object)this));
                }
                this.parentTile.removeCovering(this);
            }
        };
        return answer;
    }

    private void calculatePosition() {
        double currentZoom = this.mapArea.zoomProperty().get();
        int visibleWindow = (int)Math.floor(currentZoom + 0.2);
        if (visibleWindow == this.myZoom || this.isCovering() || visibleWindow >= 20 && this.myZoom == 19) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        if (this.debug) {
            System.out.println("visible tile " + (Object)((Object)this) + "? " + this.isVisible() + (this.isVisible() ? " covering? " + this.isCovering() : ""));
            if (this.isVisible() && this.isCovering()) {
                System.out.println("covering for " + this.covering);
            }
        }
        double sf = Math.pow(2.0, currentZoom - (double)this.myZoom);
        this.scale.setX(sf);
        this.scale.setY(sf);
        this.setTranslateX((double)(256L * this.i) * sf);
        this.setTranslateY((double)(256L * this.j) * sf);
    }

    public MapTileType getTileType() {
        return this.tileType;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            new LoadQueueConsumer(i).start();
        }
    }

    private static class LoadQueueConsumer
    extends Thread {
        public LoadQueueConsumer(int no) {
            super("MaptTileLoadQueueConsumer-" + no);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("MaptTileLoadQueueConsumer");
            while (true) {
                MapTile mt = null;
                List list = loadQueue;
                synchronized (list) {
                    if (loadQueue.isEmpty()) {
                        try {
                            loadQueue.wait();
                        }
                        catch (Exception e) {
                            log.error("Exception in wait", (Throwable)e);
                            continue;
                        }
                    }
                    if (!loadQueue.isEmpty()) {
                        mt = (MapTile)((Object)loadQueue.remove(0));
                        log.debug("Got tile from queue {}, current size {}", (Object)mt, (Object)loadQueue.size());
                    }
                }
                if (mt == null) continue;
                try {
                    mt.download();
                }
                catch (Exception e) {
                    log.warn("Exception downloading tile. Requeing", (Throwable)e);
                    List list2 = loadQueue;
                    synchronized (list2) {
                        loadQueue.add(0, mt);
                        loadQueue.notify();
                    }
                }
            }
        }
    }
}

