/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.stage;

import com.anahata.util.lang.builder.DelimitedStringBuilder;
import java.io.Serializable;
import java.util.Arrays;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagePosition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(StagePosition.class);
    private double x;
    private double y;
    private double width;
    private double height;
    private boolean maximized;

    public StagePosition(Stage s) {
        this.x = s.getX();
        this.y = s.getY();
        this.width = s.getWidth();
        this.height = s.getHeight();
        this.maximized = s.isMaximized();
    }

    public boolean isRestorable() {
        return !Screen.getScreensForRectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height).isEmpty();
    }

    public void restore(Stage s) {
        Validate.isTrue((this.maximized || this.isRestorable() ? 1 : 0) != 0, (String)("Stage position " + this + " cannot be restored"), (Object[])new Object[0]);
        if (this.maximized) {
            s.setMaximized(true);
        } else {
            s.setX(this.x);
            s.setY(this.y);
            s.setWidth(this.width);
            s.setHeight(this.height);
        }
    }

    public String toString() {
        return new DelimitedStringBuilder("#").append(this.x).append(this.y).append(this.width).append(this.height).append(this.maximized).toString();
    }

    public static StagePosition fromString(String s) {
        log.info("fromString {}", (Object)s);
        StagePosition sp = new StagePosition();
        String[] tokens = s.split("#");
        log.debug("tokens are " + Arrays.asList(tokens));
        sp.x = new Double(tokens[0]);
        sp.y = new Double(tokens[1]);
        sp.width = new Double(tokens[2]);
        sp.height = new Double(tokens[3]);
        sp.maximized = "true".equals(tokens[4]);
        return sp;
    }

    private StagePosition() {
    }
}

