/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.util.math.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;

public class BigDecimalSpinnerValueFactory
extends SpinnerValueFactory<BigDecimal> {
    private ObjectProperty<BigDecimal> min = new SimpleObjectProperty<BigDecimal>((Object)this, "min"){

        protected void invalidated() {
            BigDecimal currentValue = (BigDecimal)BigDecimalSpinnerValueFactory.this.getValue();
            if (currentValue == null) {
                return;
            }
            BigDecimal newMin = (BigDecimal)this.get();
            if (BigDecimalUtils.gt((BigDecimal)newMin, (BigDecimal)BigDecimalSpinnerValueFactory.this.getMax())) {
                BigDecimalSpinnerValueFactory.this.setMin(BigDecimalSpinnerValueFactory.this.getMax());
                return;
            }
            if (BigDecimalUtils.lt((BigDecimal)currentValue, (BigDecimal)newMin)) {
                BigDecimalSpinnerValueFactory.this.setValue(newMin);
            }
        }
    };
    private ObjectProperty<BigDecimal> max = new SimpleObjectProperty<BigDecimal>((Object)this, "max"){

        protected void invalidated() {
            BigDecimal currentValue = (BigDecimal)BigDecimalSpinnerValueFactory.this.getValue();
            if (currentValue == null) {
                return;
            }
            BigDecimal newMax = (BigDecimal)this.get();
            if (BigDecimalUtils.lt((BigDecimal)newMax, (BigDecimal)BigDecimalSpinnerValueFactory.this.getMin())) {
                BigDecimalSpinnerValueFactory.this.setMax(BigDecimalSpinnerValueFactory.this.getMin());
                return;
            }
            if (BigDecimalUtils.gt((BigDecimal)currentValue, (BigDecimal)newMax)) {
                BigDecimalSpinnerValueFactory.this.setValue(newMax);
            }
        }
    };
    private ObjectProperty<BigDecimal> amountToStepBy = new SimpleObjectProperty((Object)this, "amountToStepBy");

    public BigDecimalSpinnerValueFactory(@NamedArg(value="min") BigDecimal min, @NamedArg(value="max") BigDecimal max) {
        this(min, max, min);
    }

    public BigDecimalSpinnerValueFactory(@NamedArg(value="min") BigDecimal min, @NamedArg(value="max") BigDecimal max, @NamedArg(value="initialValue") BigDecimal initialValue) {
        this(min, max, initialValue, BigDecimal.ONE);
    }

    public BigDecimalSpinnerValueFactory(@NamedArg(value="min") BigDecimal min, @NamedArg(value="max") BigDecimal max, @NamedArg(value="initialValue") BigDecimal initialValue, @NamedArg(value="amountToStepBy") BigDecimal amountToStepBy) {
        this.setMin(min);
        this.setMax(max);
        this.setAmountToStepBy(amountToStepBy);
        this.setConverter((StringConverter)new StringConverter<BigDecimal>(){
            private final DecimalFormat df = new DecimalFormat("#.##");

            public String toString(BigDecimal value) {
                if (value == null) {
                    return "";
                }
                return this.df.format(value);
            }

            public BigDecimal fromString(String value) {
                if (value == null) {
                    return null;
                }
                if ((value = value.trim()).length() < 1) {
                    return null;
                }
                return new BigDecimal(value);
            }
        });
        this.valueProperty().addListener((o, oldValue, newValue) -> {
            if (BigDecimalUtils.lt((BigDecimal)newValue, (BigDecimal)this.getMin())) {
                this.setValue(this.getMin());
            } else if (BigDecimalUtils.gt((BigDecimal)newValue, (BigDecimal)this.getMax())) {
                this.setValue(this.getMax());
            }
        });
        this.setValue(BigDecimalUtils.ge((BigDecimal)initialValue, (BigDecimal)min) && BigDecimalUtils.le((BigDecimal)initialValue, (BigDecimal)max) ? initialValue : min);
    }

    public final void setMin(BigDecimal value) {
        this.min.set((Object)value);
    }

    public final BigDecimal getMin() {
        return (BigDecimal)this.min.get();
    }

    public final ObjectProperty<BigDecimal> minProperty() {
        return this.min;
    }

    public final void setMax(BigDecimal value) {
        this.max.set((Object)value);
    }

    public final BigDecimal getMax() {
        return (BigDecimal)this.max.get();
    }

    public final ObjectProperty<BigDecimal> maxProperty() {
        return this.max;
    }

    public final void setAmountToStepBy(BigDecimal value) {
        this.amountToStepBy.set((Object)value);
    }

    public final BigDecimal getAmountToStepBy() {
        return (BigDecimal)this.amountToStepBy.get();
    }

    public final ObjectProperty<BigDecimal> amountToStepByProperty() {
        return this.amountToStepBy;
    }

    public void decrement(int steps) {
        BigDecimal currentValue = (BigDecimal)this.getValue();
        BigDecimal minBigDecimal = this.getMin();
        BigDecimal maxBigDecimal = this.getMax();
        BigDecimal amountToStepByBigDecimal = this.getAmountToStepBy();
        BigDecimal newValue = currentValue.subtract(amountToStepByBigDecimal.multiply(new BigDecimal(steps)));
        this.setValue(newValue.compareTo(minBigDecimal) >= 0 ? newValue : (this.isWrapAround() ? BigDecimalSpinnerValueFactory.wrapValue(newValue, minBigDecimal, maxBigDecimal) : this.getMin()));
    }

    public void increment(int steps) {
        BigDecimal currentValue = (BigDecimal)this.getValue();
        BigDecimal minBigDecimal = this.getMin();
        BigDecimal maxBigDecimal = this.getMax();
        BigDecimal amountToStepByBigDecimal = this.getAmountToStepBy();
        BigDecimal newValue = currentValue.add(amountToStepByBigDecimal.multiply(new BigDecimal(steps)));
        this.setValue(newValue.compareTo(maxBigDecimal) <= 0 ? newValue : (this.isWrapAround() ? BigDecimalSpinnerValueFactory.wrapValue(newValue, minBigDecimal, maxBigDecimal) : this.getMax()));
    }

    private static BigDecimal wrapValue(BigDecimal value, BigDecimal min, BigDecimal max) {
        if (max.doubleValue() == 0.0) {
            throw new RuntimeException();
        }
        if (value.compareTo(min) < 0) {
            return max;
        }
        if (value.compareTo(max) > 0) {
            return min;
        }
        return value;
    }
}

