/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.map;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.map.Marker;
import com.anahata.jfx.map.event.MarkerListener;
import com.anahata.jfx.map.event.UBDPageOverlayListener;
import com.google.code.geocoder.model.LatLng;
import com.google.code.geocoder.model.LatLngBounds;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebMapOriginal
extends BorderPane {
    private static final Logger log = LoggerFactory.getLogger(WebMapOriginal.class);
    private static final Image ACTION_DIRECTIONS = new Image("/com/anahata/jfx/map/directions.png");
    private static final Image ACTION_WEB = new Image("/com/anahata/jfx/map/web.png");
    public static final LatLng AU_CENTER = new LatLng("-25.2743980", "133.7751360");
    public static final LatLngBounds AU_VIEWPORT = new LatLngBounds(new LatLng("-43.6583270", "112.92397210"), new LatLng("-9.22680570", "153.63867380"));
    public static final LatLngBounds EARTH_VIEWPORT = new LatLngBounds(new LatLng("-70", "30"), new LatLng("70", "140"));
    private WebEngine webEngine;
    private final List<JSFunctionCall> calls = new ArrayList<JSFunctionCall>();
    private boolean initialised = false;
    private MarkerListener markerListener;
    private UBDPageOverlayListener ubdPageOverlayListener;
    private final ToolBar toolBar;
    private final StackPane centerPane;
    private final WebView webView;
    private final Label statusLabel = new Label("Initializing map");
    private final ObjectProperty<Marker> singleMarker = new SimpleObjectProperty();
    private final StringProperty directionsSourceLocation = new SimpleStringProperty();

    public WebMapOriginal() {
        this.webView = new WebView();
        this.getStyleClass().add((Object)"webMap");
        this.webView.setVisible(false);
        this.centerPane = new StackPane();
        this.centerPane.getChildren().add((Object)this.statusLabel);
        this.centerPane.getChildren().add((Object)this.webView);
        this.statusLabel.visibleProperty().bind((ObservableValue)this.webView.visibleProperty().not());
        this.setCenter((Node)this.centerPane);
        this.webView.setOnDragDetected(t -> {});
        this.webEngine = this.webView.getEngine();
        this.webEngine.setOnAlert(event -> log.debug("{} javascript alert: {}", (Object)this, (Object)event));
        this.webEngine.load(((Object)((Object)this)).getClass().getResource("googlemap.html").toString());
        this.webEngine.documentProperty().addListener((observable, oldValue, newValue) -> this.initialiseMap());
        this.webEngine.getLoadWorker().stateProperty().addListener((ov, olsState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                JSObject jsobj = (JSObject)this.webEngine.executeScript("window");
                jsobj.setMember("java", new JavaBridgeImpl());
            }
        });
        ToggleGroup mapTypeGroup = new ToggleGroup();
        ToggleButton road = new ToggleButton("Road");
        road.setToggleGroup(mapTypeGroup);
        ToggleButton satellite = new ToggleButton("Satellite");
        satellite.setToggleGroup(mapTypeGroup);
        ToggleButton hybrid = new ToggleButton("Hybrid");
        hybrid.setToggleGroup(mapTypeGroup);
        hybrid.setSelected(true);
        ToggleButton terrain = new ToggleButton("Terrain");
        terrain.setToggleGroup(mapTypeGroup);
        mapTypeGroup.selectedToggleProperty().addListener((observableValue, toggle, toggle1) -> {
            if (road.isSelected()) {
                this.webEngine.executeScript("document.setMapTypeRoad()");
            } else if (satellite.isSelected()) {
                this.webEngine.executeScript("document.setMapTypeSatellite()");
            } else if (hybrid.isSelected()) {
                this.webEngine.executeScript("document.setMapTypeHybrid()");
            } else if (terrain.isSelected()) {
                this.webEngine.executeScript("document.setMapTypeTerrain()");
            }
        });
        Button directions = new Button("", (Node)JfxUtils.makeIcon(ACTION_DIRECTIONS, 16));
        directions.setOnAction(actionEvent -> this.openGoogleMapsDirectionsInBrowser());
        directions.visibleProperty().bind((ObservableValue)this.directionsSourceLocation.isNotNull().and((ObservableBooleanValue)this.singleMarker.isNotNull()));
        Button web = new Button("", (Node)JfxUtils.makeIcon(ACTION_WEB, 16));
        web.setOnAction(actionEvent -> this.openInBrowser());
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            web.setDisable(true);
            directions.setDisable(true);
        }
        this.toolBar = new ToolBar();
        this.toolBar.setDisable(true);
        this.toolBar.getItems().addAll((Object[])new Node[]{road, satellite, hybrid, terrain, WebMapOriginal.createSpacer(), directions, web});
        this.toolBar.disableProperty().bind((ObservableValue)this.webView.visibleProperty().not());
        this.setTop((Node)this.toolBar);
    }

    private static void enableFirebug(WebEngine engine) {
        engine.executeScript("if (!document.getElementById('FirebugLite')){E = document['createElement' + 'NS'] && document.documentElement.namespaceURI;E = E ? document['createElement' + 'NS'](E, 'script') : document['createElement']('script');E['setAttribute']('id', 'FirebugLite');E['setAttribute']('src', 'https://getfirebug.com/' + 'firebug-lite.js' + '#startOpened');E['setAttribute']('FirebugLite', '4');(document['getElementsByTagName']('head')[0] || document['getElementsByTagName']('body')[0]).appendChild(E);E = new Image;E['setAttribute']('src', 'https://getfirebug.com/' + '#startOpened');}");
    }

    public void setDirectionsSourceLocation(String directionsSource) {
        this.directionsSourceLocation.set((Object)directionsSource);
    }

    private void openGoogleMapsDirectionsInBrowser() {
        if (this.singleMarker.get() != null && this.directionsSourceLocation.get() != null) {
            try {
                String saddr = (String)this.directionsSourceLocation.get();
                String daddr = ((Marker)this.singleMarker.get()).getLocation();
                StringBuilder sb = new StringBuilder("saddr=");
                sb.append(URLEncoder.encode(saddr, "UTF-8"));
                sb.append("&daddr=");
                sb.append(URLEncoder.encode(daddr, "UTF-8"));
                sb.append("&hl=en");
                this.openGoogleMapsInBrowser(sb.toString());
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void openInBrowser() {
        Marker marker = (Marker)this.singleMarker.get();
        String queryString = null;
        if (marker != null && marker.getLocation() != null) {
            try {
                queryString = "q=" + URLEncoder.encode(marker.getLocation(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("exception encoding location on google map open-in-browser-url", (Throwable)e);
            }
        } else {
            String ll = new JSFunctionCall("getCenterURL", new Object[0]).execute().toString();
            String zoom = new JSFunctionCall("getZoom", new Object[0]).execute().toString();
            queryString = "ll=" + ll + "&z=" + zoom;
        }
        this.openGoogleMapsInBrowser(queryString);
    }

    private void openGoogleMapsInBrowser(String queryString) {
        try {
            String url = "https://maps.google.com.au/maps?" + queryString;
            log.debug("Launching google map in browser {}", (Object)url);
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | URISyntaxException ex) {
            log.error("Exception launching browser", (Throwable)ex);
        }
    }

    public void displayMap(String location, boolean fitbounds, Integer zoom, List<Marker> markers) {
        this.showMap();
        this.calls.clear();
        this.calls.add(this.jsClearMarkers());
        this.calls.add(this.jsGoToLocation(location, fitbounds));
        if (zoom != null) {
            this.calls.add(this.jsSetZoom(zoom));
        }
        if (markers != null) {
            markers.stream().filter(marker -> marker != null).forEach(marker -> this.calls.add(this.jsAddMarker((Marker)marker)));
        }
        this.executeCalls();
    }

    public void displayMap(Marker marker) {
        this.displayMap(marker, null);
    }

    public void displayMap(Marker marker, Integer zoom) {
        Validate.notNull((Object)marker);
        this.singleMarker.set((Object)marker);
        this.showMap();
        this.calls.clear();
        this.calls.add(this.jsClearMarkers());
        if (marker.getCoords() != null) {
            this.calls.add(this.jsGoToCoords(marker.getCoords(), null));
        } else {
            this.calls.add(this.jsGoToLocation(marker.getLocation(), false));
        }
        this.calls.add(this.jsAddMarker(marker));
        if (zoom != null) {
            this.calls.add(this.jsSetZoom(zoom));
        }
        this.executeCalls();
    }

    public void showMap() {
        this.webView.setVisible(true);
    }

    public void hideMap(String statusMessage) {
        this.statusLabel.setText(statusMessage);
        this.webView.setVisible(false);
    }

    public void showAddressNotFound() {
        this.hideMap("Address Not found");
    }

    public void updateViewport(LatLng center, LatLngBounds viewPort) {
        this.showMap();
        this.calls.add(this.jsGoToCoords(center, viewPort));
        this.executeCalls();
    }

    public void setMarkers(List<Marker> markers) {
        this.singleMarker.set(null);
        this.calls.clear();
        this.calls.add(this.jsClearMarkers());
        if (markers != null) {
            markers.stream().filter(marker -> marker != null).forEach(marker -> this.calls.add(this.jsAddMarker((Marker)marker)));
        }
        this.executeCalls();
    }

    public void addOverlay(String localityId, String latlongJsonStr) {
        if (localityId == null || localityId.isEmpty() || latlongJsonStr == null || latlongJsonStr.isEmpty()) {
            throw new IllegalArgumentException("Locality name or latlong json string cannot be empty.");
        }
        this.calls.add(this.jsAddOverlay(localityId, latlongJsonStr));
        this.executeCalls();
    }

    public void removeOverlay(String localityId) {
        if (localityId == null || localityId.isEmpty()) {
            throw new IllegalArgumentException("Locality name cannot be empty.");
        }
        this.calls.add(this.jsRemoveOverlay(localityId));
        this.executeCalls();
    }

    public void removeAllOverlays() {
        this.calls.add(this.jsRemoveAllOverlays());
        this.executeCalls();
    }

    private void executeCalls() {
        if (this.initialised) {
            this.calls.stream().forEach(call -> call.execute());
            this.calls.clear();
        }
    }

    private JSFunctionCall jsGoToLocation(String location, boolean fitbounds) {
        return new JSFunctionCall("goToLocation", location, fitbounds);
    }

    private JSFunctionCall jsGoToCoords(LatLng center, LatLngBounds viewPort) {
        if (viewPort != null) {
            return new JSFunctionCall("goToCoords", center.getLat(), center.getLng(), viewPort.getSouthwest().getLat(), viewPort.getSouthwest().getLng(), viewPort.getNortheast().getLat(), viewPort.getNortheast().getLng());
        }
        return new JSFunctionCall("goToCoords", center.getLat(), center.getLng());
    }

    private JSFunctionCall jsAddMarker(Marker marker) {
        String icon = marker.getIcon();
        if (icon != null) {
            icon = "../../../../.." + icon;
        }
        if (marker.getCoords() != null) {
            return new JSFunctionCall("addMarkerByCoords", marker.getId(), marker.getCoords().getLat(), marker.getCoords().getLng(), marker.getTitle(), icon);
        }
        return new JSFunctionCall("addMarkerByLocation", marker.getId(), marker.getLocation(), marker.getTitle(), icon);
    }

    private JSFunctionCall jsSetZoom(int level) {
        return new JSFunctionCall("setZoom", level);
    }

    private JSFunctionCall jsClearMarkers() {
        return new JSFunctionCall("clearMarkers", new Object[0]);
    }

    private JSFunctionCall jsAddOverlay(String localityId, String latlongJsonStr) {
        return new JSFunctionCall("addOverlay", localityId, latlongJsonStr);
    }

    private JSFunctionCall jsRemoveOverlay(String localityId) {
        return new JSFunctionCall("removeOverlay", localityId);
    }

    private JSFunctionCall jsRemoveAllOverlays() {
        return new JSFunctionCall("removeAllOverlays", new Object[0]);
    }

    private void initialiseMap() {
        log.debug("{} initialiseMap() setting window members", (Object)this);
        log.debug("{} calling document.initMap()", (Object)this);
        Boolean ret = (Boolean)new JSFunctionCall("initMap", new Object[0]).execute();
        if (ret == null) {
            log.debug("returned null");
        }
        if (ret.booleanValue()) {
            log.debug("{} document.initialise() OK returned {}, pending calls: {}", new Object[]{this, ret, this.calls.size()});
            this.initialised = true;
            this.webView.setVisible(true);
            this.executeCalls();
        } else {
            log.error("{} document.initialise() KO returned {} ", (Object)this, (Object)ret);
        }
    }

    private static Node createSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public MarkerListener getMarkerListener() {
        return this.markerListener;
    }

    public void setMarkerListener(MarkerListener markerListener) {
        this.markerListener = markerListener;
    }

    public UBDPageOverlayListener getUbdPageOverlayListener() {
        return this.ubdPageOverlayListener;
    }

    public void setUbdPageOverlayListener(UBDPageOverlayListener ubdPageOverlayListener) {
        this.ubdPageOverlayListener = ubdPageOverlayListener;
    }

    public class JavaBridgeImpl
    implements JavascriptToJavaBridge {
        @Override
        public void markerClicked(Object id) {
            if (WebMapOriginal.this.markerListener != null) {
                WebMapOriginal.this.markerListener.markerClicked(id);
            } else {
                log.debug("Marker {} clicked but no listener set");
            }
        }

        @Override
        public void locationGecodingError() {
            log.debug("locationGecodingError()");
            WebMapOriginal.this.showAddressNotFound();
        }

        @Override
        public void ubdPageClicked(Object id) {
            if (WebMapOriginal.this.ubdPageOverlayListener != null) {
                WebMapOriginal.this.ubdPageOverlayListener.ubdPageClicked(id);
            } else {
                log.debug("Locality {} clicked but no listener set", id);
            }
        }
    }

    public static interface JavascriptToJavaBridge {
        public void locationGecodingError();

        public void markerClicked(Object var1);

        public void ubdPageClicked(Object var1);
    }

    private class JSFunctionCall {
        private final String method;
        private final Object[] args;

        public JSFunctionCall(String method, Object ... args) {
            this.method = method;
            this.args = args;
        }

        public Object execute() {
            log.debug("{} executing js {}", (Object)WebMapOriginal.this, (Object)this);
            JSObject jsObject = (JSObject)WebMapOriginal.this.webEngine.executeScript("document");
            try {
                Object o = jsObject.call(this.method, this.args);
                log.debug("{} executed js ok result =, call ={}", new Object[]{WebMapOriginal.this, o, this});
                return o;
            }
            catch (JSException e) {
                log.warn("Javascript call " + this.method + " " + Arrays.asList(this.args) + " threw exception ", (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return "WebMapOriginal.JSFunctionCall(method=" + this.method + ", args=" + Arrays.deepToString(this.args) + ")";
        }
    }
}

