/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.AustralianEnglish;
import org.languagetool.rules.RuleMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextEditor
extends VBox {
    private static final Logger log = LoggerFactory.getLogger(TextEditor.class);
    private double textAreaHeight;
    final StyleClassedTextArea textArea = new StyleClassedTextArea();
    final VBox bottom = new VBox();
    final Label currentRule = new Label();
    static final JLanguageTool languageTool = new JLanguageTool((Language)new AustralianEnglish());
    private List<RuleMatch> rules = new ArrayList<RuleMatch>();

    public TextEditor() {
        this.getStylesheets().add((Object)("/com/anahata/jfx/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css"));
        this.init();
    }

    private void init() {
        this.check();
        this.getChildren().addAll((Object[])new Node[]{this.textArea, this.bottom});
        this.bottom.maxWidthProperty().bind((ObservableValue)this.textArea.widthProperty());
        this.textArea.getStyleClass().add((Object)"text-editor-text-area");
        this.getStyleClass().add((Object)"text-editor");
        this.textArea.textProperty().addListener(o -> {
            this.check();
            this.styleTextArea();
            this.renderBottom();
        });
        this.textArea.caretPositionProperty().addListener((a, b, c) -> this.renderBottom());
    }

    public void setText(String text) {
        this.textArea.replaceText(0, this.textArea.getText().length(), text);
    }

    public String getText(String text) {
        return this.textArea.getText();
    }

    public double getTextAreaHeight() {
        return this.textAreaHeight;
    }

    public void setTextAreaHeight(double textAreaHeight) {
        this.textAreaHeight = textAreaHeight;
        this.textArea.setPrefHeight(textAreaHeight);
        this.textArea.setMaxHeight(textAreaHeight);
        this.textArea.setMinHeight(textAreaHeight);
    }

    public ObservableValue<String> textProperty() {
        return this.textArea.textProperty();
    }

    private void check() {
        try {
            this.rules = languageTool.check(this.textArea.getText());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void styleTextArea() {
        this.textArea.clearStyle(0, this.textArea.getText().length());
        this.rules.forEach(rm -> {
            boolean typo = rm.getRule().getId().startsWith("MORFOLOGIK_RULE");
            String style = typo ? "spell-typo" : "spell-other";
            this.textArea.setStyle(rm.getFromPos(), rm.getToPos(), Collections.singletonList(style));
        });
    }

    private void renderBottom() {
        this.bottom.getChildren().clear();
        int count = 1;
        for (RuleMatch rm : this.rules) {
            if (rm.getFromPos() <= this.textArea.getCaretPosition() && rm.getToPos() >= this.textArea.getCaretPosition()) {
                VBox content = new VBox();
                String text = this.textArea.getText(rm.getFromPos(), rm.getToPos());
                Text label = new Text(count + " - " + text + " : " + rm.getMessage());
                label.getStyleClass().add((Object)"typo-message");
                label.wrappingWidthProperty().bind((ObservableValue)this.bottom.widthProperty());
                content.getChildren().add((Object)label);
                if (!rm.getSuggestedReplacements().isEmpty()) {
                    FlowPane suggestionsFlowPane = new FlowPane();
                    suggestionsFlowPane.getChildren().add((Object)new Label("Suggestions:"));
                    content.getChildren().add((Object)suggestionsFlowPane);
                    VBox.setMargin((Node)suggestionsFlowPane, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
                    for (String suggestedReplacement : rm.getSuggestedReplacements()) {
                        Hyperlink hl = new Hyperlink(suggestedReplacement);
                        hl.setOnAction(e -> {
                            this.textArea.replaceText(rm.getFromPos(), rm.getToPos(), suggestedReplacement);
                            this.textArea.moveTo(rm.getFromPos() + suggestedReplacement.length());
                            Platform.runLater(() -> this.textArea.requestFocus());
                        });
                        suggestionsFlowPane.getChildren().add((Object)hl);
                    }
                }
                this.bottom.getChildren().add((Object)content);
            }
            ++count;
        }
    }

    public StyleClassedTextArea getTextArea() {
        return this.textArea;
    }
}

