/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.config;

import com.anahata.jfx.config.JavaFXDynamicConfig;
import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.props.StructuredProperties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class JavaFXConfig {
    private static final String PROPS_PREFIX = "anahatajfx";
    @Inject
    private ApplicationPropertiesFactory appProps;
    @Inject
    private JavaFXDynamicConfig dynamicConfig;
    private double messageGrowlFadeInMillis;
    private double messageGrowlFadeOutMillis;
    private double messageGrowlPauseMillis;
    private String deleteIcon;
    private String readOnlyCss;

    @PostConstruct
    void postConstruct() {
        StructuredProperties props = new StructuredProperties(this.appProps.getAppProperties(), new String[]{PROPS_PREFIX});
        this.messageGrowlFadeInMillis = props.getDouble("message.growl.fadein.millis");
        this.messageGrowlFadeOutMillis = props.getDouble("message.growl.fadeout.millis");
        this.messageGrowlPauseMillis = props.getDouble("message.growl.pause.millis");
        this.deleteIcon = props.getString("icon.delete");
        this.readOnlyCss = props.getString("css.readonly");
    }

    public String getCssPath() {
        return this.dynamicConfig.getCssPath();
    }

    public String getReadOnlyCssPath() {
        return this.getCssPath() + "/" + this.readOnlyCss;
    }

    public ApplicationPropertiesFactory getAppProps() {
        return this.appProps;
    }

    public JavaFXDynamicConfig getDynamicConfig() {
        return this.dynamicConfig;
    }

    public double getMessageGrowlFadeInMillis() {
        return this.messageGrowlFadeInMillis;
    }

    public double getMessageGrowlFadeOutMillis() {
        return this.messageGrowlFadeOutMillis;
    }

    public double getMessageGrowlPauseMillis() {
        return this.messageGrowlPauseMillis;
    }

    public String getDeleteIcon() {
        return this.deleteIcon;
    }

    public String getReadOnlyCss() {
        return this.readOnlyCss;
    }
}

