/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.Binding;
import com.anahata.jfx.bind.View;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.scene.Node;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;

@Dependent
public abstract class BindingController
implements BindForm {
    @Inject
    private Binder binder;
    private boolean binderInit = false;

    public final void initialize() {
        this.init();
        this.binder.init(this);
        this.binderInit = true;
        this.postInit();
    }

    public final Binder getBinder() {
        Validate.validState((boolean)this.binderInit, (String)"Binder access was attempted without registering it first", (Object[])new Object[0]);
        return this.binder;
    }

    protected void init() {
    }

    protected void postInit() {
    }

    @Override
    public Binder getRootBinder() {
        return this.binder.getRootBinder();
    }

    @Override
    public void setRootBinder(Binder binder) {
        this.binder.setRootBinder(binder);
    }

    @Override
    public BindForm getParentBindForm() {
        return this.binder.getParentBindForm();
    }

    @Override
    public void setParentBindForm(BindForm parentBindForm) {
        this.binder.setParentBindForm(parentBindForm);
    }

    @Override
    public Binding getParentBinding() {
        return this.binder.getParentBinding();
    }

    @Override
    public void setParentBinding(Binding parentBinding) {
        this.binder.setParentBinding(parentBinding);
    }

    @Override
    public View getView(Binding binding) {
        return this.binder.getView(binding);
    }

    @Override
    public void setView(View view, Binding binding) {
        this.binder.setView(view, binding);
    }

    @Override
    public void resetFormModified() {
        this.binder.resetFormModified();
    }

    @Override
    public Map<Node, Binding> getAllNodeBindings() {
        return this.binder.getAllNodeBindings();
    }

    @Override
    public void bindFromModel() {
        this.binder.bindFromModel();
    }

    @Override
    public void bindFromModelExcludingNode(Object node) {
        this.binder.bindFromModelExcludingNode(node);
    }

    @Override
    public void validate(boolean publishError, Object ... excludeNodes) {
        this.binder.validate(publishError, excludeNodes);
    }

    @Override
    public BooleanProperty formValidProperty() {
        return this.binder.formValidProperty();
    }

    @Override
    public BooleanProperty formModifiedProperty() {
        return this.binder.formModifiedProperty();
    }

    @Override
    public BooleanProperty showContainerErrors() {
        return this.binder.showContainerErrors();
    }

    @Override
    public void setExcludeNodes(Object ... nodes) {
        this.binder.setExcludeNodes(nodes);
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        this.binder.addValidationGroup(validationGroup);
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        this.binder.removeValidationGroup(validationGroup);
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        return this.binder.getValidationActive(validationGroup);
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        return this.binder.getFormValidProperty(validationGroup);
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        this.binder.setValid(propertyName, validationGroup);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        this.binder.setInvalid(propertyName, validationGroup);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.binder.getValidations();
    }

    @Override
    public void setValidationRequired() {
        this.binder.setValidationRequired();
    }
}

