/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.JfxUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScrollPaneUtils {
    private static final Logger log = LoggerFactory.getLogger(ScrollPaneUtils.class);

    public static boolean isVisible(ScrollPane sp, Node node) {
        double nodeY = JfxUtils.yDistanceInAncestor(node, (Parent)sp.getContent());
        double contentHeight = sp.getContent().getBoundsInLocal().getHeight();
        double scrollPaneHeight = sp.getViewportBounds().getHeight();
        double currentY = sp.getVvalue();
        double visibleFrom = contentHeight * currentY;
        double visibleTo = visibleFrom + scrollPaneHeight;
        System.out.println("currentY " + currentY);
        System.out.println("contentHeight " + contentHeight);
        System.out.println("nodeY " + nodeY + " visibleFrom" + visibleFrom + " visibleTo" + visibleTo + " contentHeight" + contentHeight);
        System.out.println("nodeY > visibleFrom" + (nodeY > visibleFrom));
        System.out.println("nodeY < visibleTo" + (nodeY < visibleTo));
        return nodeY > visibleFrom && nodeY < visibleTo;
    }

    public static void scrollTo(ScrollPane sp, Node node, double offSet) {
        double h = sp.getContent().getBoundsInLocal().getHeight();
        double v = sp.getViewportBounds().getHeight();
        double y = JfxUtils.yDistanceInAncestor(node, (Parent)sp.getContent());
        y = Math.max(0.0, y + offSet);
        double newValue = sp.getVmax() * (y / (h - v));
        log.debug("scrolling pane currValue = {} newValue={} ", (Object)sp.getVvalue(), (Object)newValue);
        sp.setVvalue(newValue);
    }

    private ScrollPaneUtils() {
    }
}

