/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.validator;

import com.anahata.jfx.bind.View;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.GroupBuilder;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationBubble {
    private static final Logger log = LoggerFactory.getLogger(ValidationBubble.class);
    private static final double X_OFFSET = 10.0;
    private static final double HEIGHT = 20.0;
    private static final double Y_OFFSET = 20.0;
    private Group group;
    private VBox vbox;
    private Label message = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().styleClass(new String[]{"validationBubbleMessage"})).prefWidth(-1.0)).minWidth(-1.0)).maxWidth(Double.MAX_VALUE)).prefHeight(-1.0)).minHeight(-1.0)).maxHeight(-1.0)).build();
    private boolean inParent = false;
    private View view = null;
    private Node node = null;

    public ValidationBubble() {
        this.vbox = ((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().styleClass(new String[]{"validationBubble"})).minWidth(-1.0)).maxWidth(Double.MAX_VALUE)).prefWidth(-1.0)).children(new Node[]{this.message})).build();
        this.group = ((GroupBuilder)GroupBuilder.create().managed(false)).children(new Node[]{this.vbox}).build();
    }

    public void show(View view, Node node, String text) {
        Validate.notNull((Object)view);
        Validate.notNull((Object)node);
        log.debug("show: current={} new={}", (Object)this.message.getText(), (Object)text);
        if (!StringUtils.equals((CharSequence)text, (CharSequence)this.message.getText())) {
            this.hide();
        }
        if (!this.inParent) {
            this.inParent = true;
            this.view = view;
            this.node = node;
            log.debug("show: Adding group {} node {} to pane {}", new Object[]{System.identityHashCode(this.group), System.identityHashCode(node), view.getPane()});
            this.message.setText(text);
            this.group.relocate(0.0, 0.0);
            view.getPane().getChildren().add((Object)this.group);
            this.group.setMouseTransparent(true);
            this.group.toFront();
            this.updateCoords();
        }
    }

    private void updateCoords() {
        try {
            this.group.snapshot(null, null);
        }
        catch (Exception e) {
            log.warn("Exceptio taking component snapshot");
        }
        Bounds bounds = this.getNodeBoundsInPane(this.node, this.view.getPane());
        double x = bounds.getMaxX() - 10.0;
        double y = bounds.getMinY() - 20.0;
        Bounds viewBounds = this.view.getPane().getBoundsInLocal();
        Bounds groupBounds = this.group.getBoundsInLocal();
        if (x + groupBounds.getWidth() > viewBounds.getWidth() && (x = bounds.getMinX() - groupBounds.getWidth()) < 0.0) {
            x = viewBounds.getWidth() - groupBounds.getWidth();
        }
        log.debug("show: x={} y={} view width={} height={} group x={} y={} width={} height={}", new Object[]{x, y, viewBounds.getWidth(), viewBounds.getHeight(), groupBounds.getMinX(), groupBounds.getMinY(), groupBounds.getWidth(), groupBounds.getHeight()});
        this.group.relocate(x, y);
    }

    public void hide() {
        if (this.inParent) {
            log.debug("hide: Removing group");
            this.view.getPane().getChildren().remove((Object)this.group);
            this.inParent = false;
        }
    }

    private Bounds getNodeBoundsInPane(Node node, Pane pane) {
        Pane currPane = node instanceof Pane ? (Pane)node : null;
        Bounds nodeBounds = node.getBoundsInParent();
        double x = nodeBounds.getMinX();
        double y = nodeBounds.getMinY();
        while (node.getParent() != null) {
            if ((node = node.getParent()) instanceof Pane) {
                currPane = (Pane)node;
            }
            if (currPane != null && currPane.equals(pane)) break;
            Bounds bounds = node.getBoundsInParent();
            x += bounds.getMinX();
            y += bounds.getMinY();
        }
        if (currPane == null) {
            log.error("Ancestor Pane note found for node {}. View pane = {} ", (Object)node, (Object)pane);
        }
        return new BoundingBox(x, y, nodeBounds.getWidth(), nodeBounds.getHeight());
    }
}

