/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.validator;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.ScrollPaneUtils;
import com.anahata.jfx.bind.table.BindingTableCell;
import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.message.JfxMessageContext;
import com.anahata.jfx.validator.ValidationBubble;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javax.enterprise.context.Dependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DynamicValidationMarker {
    private static final Logger log = LoggerFactory.getLogger(DynamicValidationMarker.class);
    private static final String STYLE_NONE = "-fx-border-color: null; -fx-border-radius: null;";
    private static final String STYLE_WARN = "-fx-border-color: orange; -fx-border-radius: 2;";
    private static final String STYLE_ERROR = "-fx-border-color: red; -fx-border-radius: 2;";
    private Map<Node, ValidationBubble> bubbles = new WeakHashMap<Node, ValidationBubble>();

    public void addMessage(JfxMessageContext messageEvent) {
        Node node = messageEvent.getNode();
        if (node == null) {
            return;
        }
        JfxMessage message = messageEvent.getMessage();
        if (!message.isWarnOrHigher()) {
            return;
        }
        this.ensureNodeVisible(node);
        ValidationBubble bubble = this.bubbles.get(node);
        if (bubble == null) {
            bubble = new ValidationBubble();
            this.bubbles.put(node, bubble);
        }
        bubble.show(messageEvent.getView(), node, message.getMessage());
        this.setStyleClass(node, message.getSeverity());
    }

    private void ensureNodeVisible(Node node) {
        System.out.println("private void ensureNodeVisible(Node node) " + node + " parent = " + node.getParent());
        block0: for (Parent currentParent = node.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (currentParent instanceof ScrollPane) {
                ScrollPane sp = (ScrollPane)currentParent;
                boolean visible = ScrollPaneUtils.isVisible(sp, node);
                log.debug("Node " + node + " visible in ancestor scrollPane " + sp + ": " + visible);
                if (visible) continue;
                ScrollPaneUtils.scrollTo(sp, node, -20.0);
                continue;
            }
            if (currentParent instanceof TabPane) {
                TabPane tp = (TabPane)currentParent;
                for (Tab t : tp.getTabs()) {
                    if (t.isSelected()) continue;
                    Node tabContent = t.getContent();
                    if (tabContent == node || JfxUtils.isInAncestor(node, tabContent)) {
                        log.debug("Node " + node + " not visible in tab " + t.getText());
                        tp.getSelectionModel().select((Object)t);
                        continue block0;
                    }
                    log.debug("Node " + node + " not in tab " + t.getText());
                }
                continue;
            }
            if (currentParent instanceof BindingTableCell) {
                BindingTableCell btc = (BindingTableCell)currentParent;
                TableView tableView = btc.getTableView();
                tableView.scrollToColumn(btc.getTableColumn());
                tableView.scrollTo(btc.getBindingTableRow().getModel());
                log.debug("Node " + node + ": ancestor " + currentParent + ". scrolled to row for item " + btc.getBindingTableRow().getModel() + " and to column " + btc.getTableColumn().getText());
                continue;
            }
            log.debug("Node " + node + ": ancestor " + currentParent + " is not scroll pane");
        }
    }

    public void clearMessages(Node node) {
        ValidationBubble bubble = this.bubbles.get(node);
        if (bubble != null) {
            bubble.hide();
        }
        this.removeStyleClasses(node);
    }

    public void clearAllMessages() {
        System.out.println("clear all messages");
        for (Node node : this.bubbles.keySet()) {
            ValidationBubble bubble = this.bubbles.get(node);
            bubble.hide();
            this.removeStyleClasses(node);
        }
        this.bubbles.clear();
    }

    private void setStyleClass(Node node, JfxMessage.Severity severity) {
        if (severity == JfxMessage.Severity.INFO) {
            return;
        }
        node.setStyle(severity == JfxMessage.Severity.WARN ? STYLE_WARN : STYLE_ERROR);
    }

    private void removeStyleClasses(Node node) {
        node.setStyle(STYLE_NONE);
    }
}

