/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.bind.nodemodel.NodeModel;
import com.anahata.util.formatting.Displayable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.FlowPane;
import org.apache.commons.lang3.Validate;

public class ToggleChoiceFlowPane<T>
extends FlowPane
implements NodeModel<ToggleChoiceFlowPane, ObjectProperty> {
    private final ObjectProperty<T> value = new SimpleObjectProperty();
    private boolean block = false;

    public T getValue() {
        return (T)this.value.get();
    }

    public void setValue(T value) {
        this.value.set(value);
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public ToggleChoiceFlowPane() {
        this.setPrefHeight(-1.0);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setHgap(8.0);
        this.setVgap(8.0);
        this.value.addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> ov, T oldValue, T newValue) {
                for (Node node : ToggleChoiceFlowPane.this.getChildren()) {
                    ToggleButton tb = (ToggleButton)node;
                    Object currValue = tb.getUserData();
                    tb.setSelected(Objects.equals(currValue, newValue));
                }
            }
        });
    }

    public void init(T[] values) {
        this.init(Arrays.asList(values));
    }

    public void init(Collection<T> values) {
        Validate.notNull(values);
        this.getChildren().clear();
        this.value.setValue(null);
        for (T currValue : values) {
            String description = currValue instanceof Displayable ? ((Displayable)currValue).getDisplayValue() : currValue.toString();
            final ToggleButton cb = new ToggleButton(description);
            cb.setWrapText(true);
            cb.setUserData(currValue);
            this.getChildren().add((Object)cb);
            cb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                    if (ToggleChoiceFlowPane.this.block) {
                        return;
                    }
                    ToggleChoiceFlowPane.this.block = true;
                    Object eValue = cb.getUserData();
                    if (newValue.booleanValue()) {
                        System.out.println("Setting value to " + ToggleChoiceFlowPane.this.value);
                        ToggleChoiceFlowPane.this.value.set(eValue);
                    } else {
                        ToggleChoiceFlowPane.this.value.set(null);
                    }
                    ToggleChoiceFlowPane.this.block = false;
                }
            });
        }
    }

    @Override
    public ObjectProperty getNodeModelValueProperty(ToggleChoiceFlowPane node) {
        return node.valueProperty();
    }
}

