/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.message;

import com.anahata.jfx.config.JavaFXConfig;
import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.message.JfxMessageContext;
import com.anahata.util.cdi.Cdi;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.GroupBuilder;
import javafx.scene.Node;
import javafx.scene.control.LabelBuilder;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPaneBuilder;
import javafx.scene.layout.HBox;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.util.Duration;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class Growl {
    private static final Logger log = LoggerFactory.getLogger(Growl.class);
    private static final double WIDTH = 350.0;
    private static final double MIN_HEIGHT = 60.0;
    private static Image NOTIFY_INFO = new Image("/com/anahata/jfx/dialog/info16.png");
    private static Image NOTIFY_WARN = new Image("/com/anahata/jfx/dialog/warning16.png");
    private static Image NOTIFY_ERROR = new Image("/com/anahata/jfx/dialog/error16.png");
    private static Image NOTIFY_FATAL = new Image("/com/anahata/jfx/dialog/error16.png");
    private static Image CLOSE = new Image("/com/anahata/jfx/close12.png");
    @Inject
    private JavaFXConfig config;
    private Pane parent;
    private Group group;
    private VBox vbox;
    private Status status = Status.HIDDEN;
    private Set<JfxMessage> messages = new HashSet<JfxMessage>();
    private FadeTransition fadeIn;
    private FadeTransition fadeOut;
    private PauseTransition pause;
    private double margin = 0.0;

    public Growl(@NonNull Pane parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        while (parent.getParent() instanceof Pane) {
            if (!((parent = (Pane)parent.getParent()) instanceof AnchorPane)) continue;
            this.parent = parent;
            break;
        }
        if (this.parent == null) {
            log.warn("Growl parent is not an anchor pane. It is going to look funny.");
            this.parent = parent;
        }
        this.config = (JavaFXConfig)Cdi.get(JavaFXConfig.class, (Annotation[])new Annotation[0]);
        final ImageView closeButton = ((ImageViewBuilder)((ImageViewBuilder)((ImageViewBuilder)((ImageViewBuilder)ImageViewBuilder.create().image(CLOSE).cache(true)).visible(false)).styleClass(new String[]{"growlClose"})).onMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                Growl.this.removeFromParent();
            }
        })).build();
        this.vbox = ((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().styleClass(new String[]{"growlWindow"})).prefWidth(350.0)).prefHeight(-1.0)).minWidth(Double.NEGATIVE_INFINITY)).minHeight(60.0)).maxWidth(Double.NEGATIVE_INFINITY)).maxHeight(Double.MAX_VALUE)).build();
        this.group = ((GroupBuilder)((GroupBuilder)GroupBuilder.create().children(new Node[]{this.vbox, ((BorderPaneBuilder)((BorderPaneBuilder)((BorderPaneBuilder)BorderPaneBuilder.create().styleClass(new String[]{"growlCloseContainer"})).prefWidth(350.0)).maxWidth(Double.NEGATIVE_INFINITY)).right((Node)closeButton).build()}).onMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                closeButton.setVisible(true);
            }
        })).onMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                closeButton.setVisible(false);
            }
        })).build();
        this.pause = new PauseTransition(Duration.millis((double)this.config.getMessageGrowlPauseMillis()));
        this.pause.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Growl.this.removeFromParent();
            }
        });
        this.fadeIn = new FadeTransition(Duration.millis((double)this.config.getMessageGrowlFadeInMillis()), (Node)this.group);
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(1.0);
        this.fadeIn.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Growl.this.status = Status.SHOWN;
                Growl.this.pause.playFromStart();
            }
        });
        this.fadeOut = new FadeTransition(Duration.millis((double)this.config.getMessageGrowlFadeOutMillis()), (Node)this.group);
        this.fadeOut.setFromValue(1.0);
        this.fadeOut.setToValue(0.0);
        this.fadeOut.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Growl.this.parent.getChildren().remove((Object)Growl.this.group);
                Growl.this.status = Status.HIDDEN;
            }
        });
    }

    void addMessage(JfxMessageContext messageContext) {
        log.debug("Got a new message");
        if (messageContext.getNode() != null) {
            return;
        }
        JfxMessage message = messageContext.getMessage();
        this.addMessage(message);
    }

    public void clearAndAddMessage(JfxMessage message) {
        this.clearAllMessages();
        this.addMessage(message);
    }

    public void addMessage(JfxMessage message) {
        if (!this.messages.contains(message)) {
            this.messages.add(message);
            HBox hbox = ((HBoxBuilder)((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().spacing(4.0).userData((Object)message)).styleClass(new String[]{"growlLine"})).children(new Node[]{Growl.getSeverityImageView(message.getSeverity()), ((LabelBuilder)((LabelBuilder)LabelBuilder.create().text(message.getMessage())).wrapText(true)).build()})).build();
            this.vbox.getChildren().add((Object)hbox);
        }
        this.addToParent();
    }

    public void clearAllMessages() {
        log.debug("Clearing messages");
        this.messages.clear();
        this.vbox.getChildren().clear();
        this.removeFromParent();
    }

    private void addToParent() {
        if (this.status == Status.HIDING) {
            this.fadeOut.stop();
            this.parent.getChildren().remove((Object)this.group);
            this.status = Status.HIDDEN;
        }
        if (this.status == Status.HIDDEN) {
            this.parent.getChildren().add((Object)this.group);
            this.group.toFront();
            this.group.relocate(this.parent.getWidth() - 350.0 - this.margin, this.margin);
            this.status = Status.SHOWING;
            this.fadeIn.playFromStart();
        } else if (this.status == Status.SHOWN) {
            this.pause.playFromStart();
        }
    }

    private void removeFromParent() {
        log.debug("removeFromParent: status={}", (Object)this.status);
        if (this.status == Status.SHOWING) {
            this.fadeIn.stop();
            this.status = Status.SHOWN;
        }
        if (this.status == Status.SHOWN) {
            this.status = Status.HIDING;
            this.fadeOut.playFromStart();
        }
    }

    public static ImageView getSeverityImageView(JfxMessage.Severity severity) {
        Image image;
        Validate.notNull((Object)((Object)severity));
        switch (severity) {
            case INFO: {
                image = NOTIFY_INFO;
                break;
            }
            case WARN: {
                image = NOTIFY_WARN;
                break;
            }
            case ERROR: {
                image = NOTIFY_ERROR;
                break;
            }
            default: {
                image = NOTIFY_FATAL;
            }
        }
        ImageView iv = new ImageView(image);
        iv.setCache(true);
        return iv;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    private static enum Status {
        SHOWING,
        SHOWN,
        HIDING,
        HIDDEN;

    }
}

