/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.internal.scene.control.skin;

import com.anahata.jfx.internal.scene.control.behavior.CalendarTextFieldBehavior;
import com.anahata.jfx.scene.control.CalendarTextField;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.util.NodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarTextFieldCaspianSkin
extends BehaviorSkinBase<CalendarTextField, CalendarTextFieldBehavior> {
    private static final Logger log = LoggerFactory.getLogger(CalendarTextFieldCaspianSkin.class);
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    private CalendarPicker calendarPicker = null;
    private Image closeIconImage = null;
    private static final Date DATE_WITH_TIME = new GregorianCalendar(1111, 0, 1, 2, 2, 2).getTime();
    private Popup popup = null;

    public CalendarTextFieldCaspianSkin(CalendarTextField control) {
        super((Control)control, (BehaviorBase)new CalendarTextFieldBehavior(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTextField)this.getSkinnable()).calendarProperty().addListener((observableValue, oldValue, newValue) -> this.refreshValue());
        ((CalendarTextField)this.getSkinnable()).dateFormatProperty().addListener(observable -> this.refreshValue());
        ((CalendarTextField)this.getSkinnable()).textFieldFocusedProperty().bind((ObservableValue)this.textField.focusedProperty());
        this.refreshValue();
        this.initFocusSimulation();
    }

    private void refreshValue() {
        Calendar c = ((CalendarTextField)this.getSkinnable()).getCalendar();
        String s = c == null ? "" : ((CalendarTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
    }

    private void initFocusSimulation() {
        ((CalendarTextField)this.getSkinnable()).focusedProperty().addListener((ov, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                Platform.runLater(() -> this.textField.requestFocus());
            }
        });
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.focusTraversableProperty().bind((ObservableValue)((CalendarTextField)this.getSkinnable()).focusTraversableProperty());
        this.textField.setPrefColumnCount(20);
        this.textField.focusedProperty().addListener(arg0 -> {
            if (!this.textField.isFocused()) {
                this.parse();
            }
        });
        this.textField.setOnAction(evt -> this.parse());
        this.textField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                this.parse();
                Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                if (lCalendar == null) {
                    return;
                }
                lCalendar = (Calendar)lCalendar.clone();
                int lField = 5;
                if (!keyEvent.isShiftDown() && keyEvent.isControlDown()) {
                    lField = 2;
                }
                if (!keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                    lField = 1;
                }
                if (keyEvent.isShiftDown() && keyEvent.isControlDown() && this.isShowingTime()) {
                    lField = 11;
                }
                if (keyEvent.isShiftDown() && keyEvent.isAltDown() && this.isShowingTime()) {
                    lField = 12;
                }
                lCalendar.add(lField, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a date or use # for today, or +/-<number>[d|w|m|y] for delta's (for example: -3m for minus 3 months)\nUse cursor up and down plus optional shift (week), ctrl (month) or alt (year) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageView();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked(evt -> {
            if (this.textField.focusedProperty().get()) {
                this.parse();
            }
            this.showPopup((MouseEvent)evt);
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(100.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        ((CalendarTextField)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
        this.calendarPicker = new CalendarPicker();
        this.calendarPicker.setMode(CalendarPicker.Mode.SINGLE);
        Bindings.bindBidirectional((Property)this.calendarPicker.localeProperty(), ((CalendarTextField)this.getSkinnable()).localeProperty());
        Bindings.bindBidirectional((Property)this.calendarPicker.calendarProperty(), ((CalendarTextField)this.getSkinnable()).calendarProperty());
        this.calendarPicker.calendarProperty().addListener((observable, oldValue, newValue) -> {
            if (this.popup != null && !this.isShowingTime()) {
                this.popup.hide();
                this.popup = null;
            }
        });
        this.closeIconImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + "CloseWindowIcon.png"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        block18: {
            try {
                String lText = this.textField.getText();
                lText = lText.trim();
                if (lText.length() == 0) {
                    ((CalendarTextField)this.getSkinnable()).setCalendar(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("d")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 5;
                    }
                    if (lText.toLowerCase().endsWith("w")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 3;
                    }
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 2;
                    }
                    if (lText.toLowerCase().endsWith("y")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 1;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTextField)this.getSkinnable()).getCalendar().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                    break block18;
                }
                if (lText.equals("#")) {
                    ((CalendarTextField)this.getSkinnable()).setCalendar(Calendar.getInstance());
                    break block18;
                }
                try {
                    Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                    Date lDate = null;
                    try {
                        Iterator iterator = ((CalendarTextField)this.getSkinnable()).getDateFormats().iterator();
                        if (iterator.hasNext()) {
                            DateFormat lDateFormat = (DateFormat)iterator.next();
                            lDate = lDateFormat.parse(lText);
                        }
                        if (lDate == null) {
                            lDate = ((CalendarTextField)this.getSkinnable()).getDateFormat().parse(lText);
                        }
                        lCalendar = Calendar.getInstance();
                        lCalendar.setTime(lDate);
                        ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                finally {
                    this.refreshValue();
                }
            }
            catch (NumberFormatException t) {
                if (((CalendarTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private boolean isShowingTime() {
        String lDateAsString = ((DateFormat)((CalendarTextField)this.getSkinnable()).dateFormatProperty().get()).format(DATE_WITH_TIME);
        return lDateAsString.contains("2");
    }

    private void showPopup(MouseEvent evt) {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setAutoFix(true);
            this.popup.setAutoHide(true);
            this.popup.setHideOnEscape(true);
            BorderPane lBorderPane = new BorderPane();
            String css = "-fx-background-color: -fx-shadow-highlight-color, -fx-outer-border, -fx-inner-border, -fx-body-color;\t-fx-background-insets: 0 0 -1 0,0,1,2;\t-fx-background-radius: 5,5,4,3;\t-fx-padding: 0.766667em 0.733333em 0.75em 0.733333em;\t-fx-text-fill: -fx-text-base-color;";
            lBorderPane.setStyle(css);
            lBorderPane.setCenter((Node)this.calendarPicker);
            this.calendarPicker.showTimeProperty().set((Object)this.isShowingTime());
            if (this.isShowingTime()) {
                ImageView lImageView = new ImageView(this.closeIconImage);
                lImageView.setPickOnBounds(true);
                lImageView.setOnMouseClicked(evt1 -> {
                    this.popup.hide();
                    this.popup = null;
                });
                lBorderPane.rightProperty().set((Object)lImageView);
            }
            this.popup.getContent().add((Object)lBorderPane);
        }
        log.debug("showingPopup");
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
        this.calendarPicker.requestFocus();
    }
}

