/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.converter.string;

import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.converter.string.DoubleConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;

public class DoubleTwoFractionsConverter
implements Converter<Double, String> {
    public static DoubleConverter INSTANCE = new DoubleConverter();
    private static final DecimalFormat FORMAT = (DecimalFormat)NumberFormat.getNumberInstance();

    @Override
    public Double getAsDomainModelValue(Object node, String string) {
        if (!StringUtils.isBlank((CharSequence)(string = StringUtils.trim((String)string))) && string.matches("^\\d*(\\.\\d{0,9})?$")) {
            return (double)Math.round(Double.valueOf(string) * 100.0) / 100.0;
        }
        return null;
    }

    @Override
    public String getAsNodeModelValue(Object node, Double object) {
        return object != null ? FORMAT.format(object) : null;
    }

    @Override
    public String format(String value) {
        return value;
    }

    static {
        FORMAT.setMinimumFractionDigits(2);
        FORMAT.setMaximumFractionDigits(2);
    }
}

