/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.desktop;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.HBox;
import org.lodgon.openmapfx.core.DefaultBaseMapProvider;
import org.lodgon.openmapfx.core.MapTileType;
import org.lodgon.openmapfx.core.TileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProviderPicker
extends HBox
implements ListChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SimpleProviderPicker.class);
    private final ComboBox<TileProvider> cmbProviders;
    private final ComboBox<MapTileType> tileType;

    public SimpleProviderPicker(DefaultBaseMapProvider provider) {
        super(4.0);
        this.setStyle("-fx-padding:4px");
        if (provider.getTileProviders().isEmpty()) {
            throw new IllegalArgumentException("Providers array passed to SimpleProviderPicker cannot be null or empty.");
        }
        this.cmbProviders = new ComboBox(FXCollections.observableArrayList(provider.getTileProviders()));
        this.cmbProviders.valueProperty().addListener((obs, o, n) -> this.setCurrentTileProvider((TileProvider)n));
        this.tileType = new ComboBox();
        this.getChildren().addAll((Object[])new Node[]{this.cmbProviders, this.tileType});
        this.cmbProviders.getSelectionModel().select((Object)provider.getTileProviders().get(0));
        provider.tileProviderProperty().bind((ObservableValue)this.cmbProviders.getSelectionModel().selectedItemProperty());
        provider.tileTypeProperty().bind((ObservableValue)this.tileType.valueProperty());
    }

    public void addProvider(TileProvider provider) {
        this.cmbProviders.getItems().add((Object)provider);
    }

    public void setCurrentTileProvider(TileProvider tp) {
        this.cmbProviders.setValue((Object)tp);
        this.tileType.getItems().removeListener((ListChangeListener)this);
        log.debug("provider changed " + tp + " tileTypes=" + tp.getTileTypes());
        this.tileType.getItems().addListener((ListChangeListener)this);
        this.tileType.setItems(tp.getTileTypes());
        this.onChanged(null);
    }

    public ReadOnlyObjectProperty<MapTileType> selectedTileTypeProperty() {
        return this.tileType.getSelectionModel().selectedItemProperty();
    }

    public void onChanged(ListChangeListener.Change c) {
        System.out.println("onChanged------------- " + c);
        if (!this.tileType.getItems().isEmpty()) {
            this.tileType.setValue(this.tileType.getItems().get(0));
        }
    }
}

