/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lodgon.openmapfx.core.SettingsProvider;

public class SettingsService {
    private static final Logger LOG = Logger.getLogger(SettingsService.class.getName());
    private static SettingsService instance;
    private final ServiceLoader<SettingsProvider> loader;
    private SettingsProvider provider;

    private SettingsService() {
        LOG.log(Level.FINE, "Loading SettingsService.");
        this.loader = ServiceLoader.load(SettingsProvider.class);
        Iterator<SettingsProvider> iterator = this.loader.iterator();
        while (iterator.hasNext()) {
            if (this.provider == null) {
                this.provider = iterator.next();
                LOG.log(Level.INFO, "The following SettingsProvider will be used: {0}", this.provider);
                continue;
            }
            LOG.log(Level.INFO, "Ignoring SettingsProvider {0}.", iterator.next());
        }
        if (this.provider == null) {
            LOG.log(Level.WARNING, "No SettingsProvider could be found.");
        }
        LOG.log(Level.FINE, "Loading SettingsService completed.");
    }

    public static SettingsService getInstance() {
        if (instance == null) {
            instance = new SettingsService();
        }
        return instance;
    }

    public String getSetting(String key) {
        return this.provider.getSetting(key);
    }

    public void storeSetting(String key, String value) {
        this.provider.storeSetting(key, value);
    }

    public void removeSetting(String key) {
        this.provider.removeSetting(key);
    }
}

