/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.internal.scene.control.behavior;

import com.anahata.jfx.internal.scene.control.skin.AutoCompleteComboBoxSkin;
import com.anahata.jfx.scene.control.AutoCompleteComboBox;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteComboBoxBehavior<T>
extends ComboBoxBaseBehavior<T> {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteComboBoxBehavior.class);
    protected static final List<KeyBinding> AUTO_COMBO_BINDINGS = new ArrayList<KeyBinding>();
    private static final String SELECT_PREVIOUS_ACTION = "selectPrevious";
    private static final String SELECT_NEXT_ACTION = "selectNext";
    private static final String TOGGLE_POPUP_ACTION = "togglePopup";
    private static final String SELECT_ACTION = "select";
    private static final String SELECT_AND_TRAVERSE_ACTION = "selectAndTraverse";
    final AutoCompleteComboBox<T> combo;

    public AutoCompleteComboBoxBehavior(AutoCompleteComboBox<T> combo) {
        super(combo, AUTO_COMBO_BINDINGS);
        this.combo = combo;
    }

    public void selectAndTraverse() {
        Skin skin = this.combo.getSkin();
        if (skin instanceof AutoCompleteComboBoxSkin) {
            AutoCompleteComboBoxSkin comboSkin = (AutoCompleteComboBoxSkin)skin;
            MultipleSelectionModel selectionModel = comboSkin.getListView().getSelectionModel();
            log.trace("selectionModel={}", (Object)selectionModel);
            if (selectionModel == null) {
                return;
            }
            Object item = selectionModel.getSelectedItem();
            if (item != null) {
                this.combo.getSelectionModel().select(item);
            }
        }
        if (this.combo.isShowing()) {
            this.hide();
            this.traverseNext();
        }
    }

    public void select() {
        Skin skin = this.combo.getSkin();
        log.debug("select skin= {}", (Object)skin);
        log.debug("skin instance of ACCBS= {}", (Object)(skin instanceof AutoCompleteComboBoxSkin));
        log.debug("skin assignable of ACCBS= {}", (Object)skin.getClass().isAssignableFrom(AutoCompleteComboBoxSkin.class));
        if (skin instanceof AutoCompleteComboBoxSkin) {
            AutoCompleteComboBoxSkin comboSkin = (AutoCompleteComboBoxSkin)skin;
            MultipleSelectionModel selectionModel = comboSkin.getListView().getSelectionModel();
            log.trace("selectionModel={}", (Object)selectionModel);
            if (selectionModel == null) {
                return;
            }
            Object item = selectionModel.getSelectedItem();
            log.trace("selecting item= {}", item);
            this.combo.getSelectionModel().select(item);
            this.combo.requestFocus();
        }
    }

    public void selectPrevious() {
        Skin skin = this.combo.getSkin();
        if (this.combo.isShowing() && skin instanceof AutoCompleteComboBoxSkin) {
            AutoCompleteComboBoxSkin comboSkin = (AutoCompleteComboBoxSkin)skin;
            MultipleSelectionModel selectionModel = comboSkin.getListView().getSelectionModel();
            log.trace("selectionModel={}", (Object)selectionModel);
            if (selectionModel == null) {
                return;
            }
            selectionModel.selectPrevious();
        }
    }

    public void selectNext() {
        Skin skin = this.combo.getSkin();
        if (this.combo.isShowing() && skin instanceof AutoCompleteComboBoxSkin) {
            AutoCompleteComboBoxSkin comboSkin = (AutoCompleteComboBoxSkin)skin;
            MultipleSelectionModel selectionModel = comboSkin.getListView().getSelectionModel();
            log.trace("selectionModel={}", (Object)selectionModel);
            if (selectionModel == null) {
                return;
            }
            selectionModel.selectNext();
        }
    }

    protected void callAction(String actionName) {
        log.trace("calling action={}", (Object)actionName);
        switch (actionName) {
            case "selectPrevious": {
                this.selectPrevious();
                break;
            }
            case "selectNext": {
                this.selectNext();
                break;
            }
            case "select": {
                this.select();
                break;
            }
            case "selectAndTraverse": {
                this.selectAndTraverse();
                break;
            }
            default: {
                super.callAction(actionName);
            }
        }
    }

    static {
        AUTO_COMBO_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, SELECT_PREVIOUS_ACTION));
        AUTO_COMBO_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, SELECT_NEXT_ACTION));
        AUTO_COMBO_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_RELEASED, SELECT_ACTION));
        AUTO_COMBO_BINDINGS.add(new KeyBinding(KeyCode.TAB, KeyEvent.KEY_RELEASED, SELECT_AND_TRAVERSE_ACTION));
    }
}

