/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.layer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.lodgon.openmapfx.core.LayeredMap;
import org.lodgon.openmapfx.core.MapLayer;
import org.lodgon.openmapfx.layer.Position;

public class MultiPositionLayer
extends Parent
implements MapLayer {
    private final Map<String, Position> nodePositions = new HashMap<String, Position>();
    private double imageWidth;
    private double imageHeight;
    private LayeredMap layeredMap;

    @Override
    public Node getView() {
        return this;
    }

    public void addNode(Node node, double latitude, double longitude) {
        if (node.getId() == null) {
            node.setId(UUID.randomUUID().toString());
        }
        this.nodePositions.put(node.getId(), new Position(latitude, longitude));
        this.getChildren().add((Object)node);
    }

    public void removeNode(Node node) {
        this.nodePositions.remove(node.getId());
        this.getChildren().remove((Object)node);
    }

    public void removeAllNodes() {
        this.nodePositions.clear();
        this.getChildren().clear();
    }

    public void updatePosition(Node node, double latitude, double longitude) {
        this.nodePositions.put(node.getId(), new Position(latitude, longitude));
        this.refreshSingleLayer(node);
    }

    protected void refreshEntireLayer() {
        for (Node node : this.getChildren()) {
            this.refreshSingleLayer(node);
        }
    }

    protected void refreshSingleLayer(Node node) {
        Position nodePosition = this.nodePositions.get(node.getId());
        if (nodePosition != null) {
            Point2D cartPoint = this.layeredMap.getMapPoint(nodePosition.getLatitude(), nodePosition.getLongitude());
            if (cartPoint == null) {
                System.out.println("[JVDBG] Null cartpoint, probably no scene, dont show.");
            } else {
                node.setVisible(true);
                node.setTranslateX(cartPoint.getX() - this.imageWidth / 2.0);
                node.setTranslateY(cartPoint.getY() - this.imageHeight / 2.0);
            }
        } else {
            System.out.println("[JVDBG] Null nodePosition, probably updated a node position that was not added (node id: " + node.getId() + ".");
        }
    }

    @Override
    public void gotLayeredMap(LayeredMap map) {
        this.layeredMap = map;
        this.layeredMap.zoomProperty().addListener(e -> this.refreshEntireLayer());
        this.layeredMap.centerLatitudeProperty().addListener(e -> this.refreshEntireLayer());
        this.layeredMap.centerLongitudeProperty().addListener(e -> this.refreshEntireLayer());
        this.layeredMap.xShiftProperty().addListener(e -> this.refreshEntireLayer());
        this.layeredMap.yShiftProperty().addListener(e -> this.refreshEntireLayer());
        this.refreshEntireLayer();
    }
}

