/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.concurrent;

import com.anahata.jfx.concurrent.ApplicationTask;
import com.anahata.util.formatting.Displayable;
import com.anahata.util.progress.ProgressMessage;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BackgroundInvocationHandler.class);
    protected Node nodeToDisable;
    protected BooleanProperty runningProperty = new SimpleBooleanProperty();
    protected Object delegate;

    public static void disableWhileRunning(Node node, Object ... proxies) {
        for (Object remoteService : proxies) {
            ((BackgroundInvocationHandler)Proxy.getInvocationHandler(remoteService)).setNodeToDisable(node);
        }
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        log.debug("method {} ", (Object)method);
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        if (Platform.isFxApplicationThread()) {
            Object returnObj;
            final Object key = new Object();
            ApplicationTask applicationTask = new ApplicationTask(){

                protected Object call() throws Exception {
                    Object arg;
                    log.debug("JavaFXRemoteServiceProxy invoking {} ", (Object)method);
                    String title = "Processing";
                    if (method.isAnnotationPresent(ProgressMessage.class)) {
                        title = method.getAnnotation(ProgressMessage.class).value();
                    }
                    this.updateTitle(title);
                    String message = method.getDeclaringClass().getSimpleName() + " " + method.getName();
                    if (args != null && args.length > 0 && (arg = args[0]) instanceof Displayable) {
                        try {
                            message = message + " " + ((Displayable)arg).getDisplayValue();
                        }
                        catch (Exception e) {
                            log.warn("Could not call getDisplayValue on parameter 0 of " + title + " " + message, (Throwable)e);
                        }
                    }
                    this.updateMessage(message);
                    return method.invoke(BackgroundInvocationHandler.this.delegate, args);
                }

                protected void succeeded() {
                    Toolkit.getToolkit().exitNestedEventLoop(key, super.getValue());
                }

                protected void failed() {
                    super.failed();
                    Toolkit.getToolkit().exitNestedEventLoop(key, (Object)super.getException());
                }
            };
            if (this.runningProperty != null) {
                this.runningProperty.unbind();
                this.runningProperty.bind((ObservableValue)applicationTask.runningProperty());
            }
            if (this.nodeToDisable != null) {
                this.nodeToDisable.disableProperty().unbind();
                this.nodeToDisable.disableProperty().bind((ObservableValue)applicationTask.runningProperty());
            }
            applicationTask.launch();
            try {
                returnObj = Toolkit.getToolkit().enterNestedEventLoop(key);
            }
            catch (IllegalStateException e) {
                String msg = "Exceptiong attempting to enter the nested event loop to process the call in background.";
                throw new RuntimeException(msg, e);
            }
            if (returnObj instanceof Throwable) {
                throw (Throwable)returnObj;
            }
            return returnObj;
        }
        return method.invoke(this.delegate, args);
    }

    public static <T> T newAsynchProxy(T delegate, Node node, BooleanProperty running) {
        BackgroundInvocationHandler proxy = new BackgroundInvocationHandler();
        proxy.setDelegate(delegate);
        proxy.setNodeToDisable(node);
        if (running != null) {
            proxy.setRunningProperty(running);
        }
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), ClassUtils.getAllInterfaces(delegate.getClass()).toArray(new Class[0]), (InvocationHandler)proxy);
    }

    public void setNodeToDisable(Node nodeToDisable) {
        this.nodeToDisable = nodeToDisable;
    }

    public void setRunningProperty(BooleanProperty runningProperty) {
        this.runningProperty = runningProperty;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }
}

