/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.concurrent.ApplicationTask;
import com.anahata.util.formatting.Displayable;
import com.anahata.util.progress.ProgressMessage;
import com.anahata.util.transport.RemoteServiceProxy;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFxRemoteServiceProxy
extends RemoteServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(JavaFxRemoteServiceProxy.class);

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        log.debug("method {} ", (Object)method);
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        if (Platform.isFxApplicationThread()) {
            Object returnObj;
            if (this.nodeToDisable != null) {
                this.nodeToDisable.disableProperty().unbind();
            }
            final Object key = new Object();
            ApplicationTask applicationTask = new ApplicationTask(){

                protected Object call() throws Exception {
                    Object arg;
                    log.debug("JavaFXRemoteServiceProxy invoking {} ", (Object)method);
                    String message = "Processing";
                    if (method.isAnnotationPresent(ProgressMessage.class)) {
                        message = method.getAnnotation(ProgressMessage.class).value();
                    }
                    this.updateTitle(message);
                    if (args != null && args.length > 0 && (arg = args[0]) instanceof Displayable) {
                        this.updateMessage(((Displayable)arg).getDisplayValue());
                    }
                    return method.invoke(JavaFxRemoteServiceProxy.this.service, args);
                }

                protected void succeeded() {
                    Toolkit.getToolkit().exitNestedEventLoop(key, super.getValue());
                }

                protected void failed() {
                    super.failed();
                    Toolkit.getToolkit().exitNestedEventLoop(key, (Object)super.getException());
                }
            };
            if (this.nodeToDisable != null) {
                this.nodeToDisable.disableProperty().bind((ObservableValue)applicationTask.runningProperty());
            }
            applicationTask.launch();
            try {
                returnObj = Toolkit.getToolkit().enterNestedEventLoop(key);
            }
            catch (IllegalStateException e) {
                String msg = "Exceptiong attempting to enter the nested event loop to process the call in background. @Background annotation only works for system generated events like clicking on the moust button or a key on the keyboard. Sounds hillarious but it is true.If the remote service annotated as Backgroun is called in one of this scenarios:\n \n1) from a JMS initiated event or the application startup or \n2) at application startup or\n3) by a non javafx thread that called Platform.runLater. \nIf you want to do the server call in the background you can \n- inject the same service without the @Background annotation and do it the old way and use an ApplicationTask (cases 1 and 3)\n- move the code that calls the service from init() or postInit() to onArrival(). (case 2)\nThanks for your understanding.";
                log.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
            if (returnObj instanceof Throwable) {
                throw (Throwable)returnObj;
            }
            return returnObj;
        }
        return method.invoke(this.service, args);
    }

    public static <T> T newAsynchProxy(T service, Node node) {
        JavaFxRemoteServiceProxy proxy = new JavaFxRemoteServiceProxy();
        proxy.setService(service);
        proxy.setNodeToDisable(node);
        return (T)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.getAllInterfaces(service.getClass()).toArray(new Class[0]), (InvocationHandler)((Object)proxy));
    }
}

