/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.message;

import com.anahata.jfx.bind.View;
import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.message.JfxMessageClearContext;
import com.anahata.jfx.message.JfxMessageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;

@ApplicationScoped
public class JfxMessages {
    @Inject
    private Event<JfxMessageContext> addMessageEvent;
    @Inject
    private Event<JfxMessageClearContext> clearMessageEvent;
    @Inject
    private Event<JfxMessages> clearAllMessagesEvent;
    private List<JfxMessageContext> globalMessages = new ArrayList<JfxMessageContext>();
    private Map<Node, List<JfxMessageContext>> idMessages = new HashMap<Node, List<JfxMessageContext>>();

    public void addMessage(View view, Node node, JfxMessage message) {
        if (message == null) {
            return;
        }
        Validate.notNull((Object)view, (String)"The view is required", (Object[])new Object[0]);
        JfxMessageContext context = new JfxMessageContext(view, node, message);
        if (node == null) {
            this.globalMessages.add(context);
        } else {
            List<JfxMessageContext> messages = this.idMessages.get(node);
            if (messages == null) {
                messages = new ArrayList<JfxMessageContext>();
                this.idMessages.put(node, messages);
            }
            messages.add(context);
        }
        this.addMessageEvent.fire((Object)context);
    }

    public List<JfxMessage> getMessages() {
        ArrayList<JfxMessage> messages = new ArrayList<JfxMessage>();
        for (JfxMessageContext jfxMessageContext : this.globalMessages) {
            messages.add(jfxMessageContext.getMessage());
        }
        for (List list : this.idMessages.values()) {
            for (JfxMessageContext context : list) {
                messages.add(context.getMessage());
            }
        }
        return messages;
    }

    public List<JfxMessage> getMessages(Node node) {
        if (node == null) {
            ArrayList<JfxMessage> messages = new ArrayList<JfxMessage>();
            for (JfxMessageContext context : this.globalMessages) {
                messages.add(context.getMessage());
            }
            return messages;
        }
        List<JfxMessageContext> messageContexts = this.idMessages.get(node);
        if (messageContexts == null) {
            return Collections.emptyList();
        }
        ArrayList<JfxMessage> messages = new ArrayList<JfxMessage>();
        for (JfxMessageContext context : messageContexts) {
            messages.add(context.getMessage());
        }
        return messages;
    }

    public void clearMessages() {
        this.globalMessages.clear();
        this.idMessages.clear();
        this.clearAllMessagesEvent.fire((Object)this);
    }

    public void clearAndAddMessage(View view, Node node, JfxMessage message) {
        this.clearMessages();
        this.addMessage(view, node, message);
    }

    public void clearIdMessages() {
        for (Map.Entry<Node, List<JfxMessageContext>> entry : this.idMessages.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            this.clearMessageEvent.fire((Object)new JfxMessageClearContext(entry.getKey()));
        }
    }

    public void clearMessage(Node node) {
        Validate.notNull((Object)node);
        List<JfxMessageContext> messages = this.idMessages.get(node);
        if (messages != null) {
            if (!messages.isEmpty()) {
                this.clearMessageEvent.fire((Object)new JfxMessageClearContext(node));
            }
            messages.clear();
        }
    }
}

