/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.concurrent;

import com.anahata.jfx.JavaFxRemoteServiceProxy;
import com.anahata.jfx.concurrent.Background;
import com.anahata.jfx.concurrent.BackgroundDisable;
import com.anahata.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.List;
import javafx.scene.Node;
import lombok.NonNull;

public class BackgroundProcessor {
    public static void process(@NonNull Object controller, Node node) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        try {
            Object o;
            Node n = node;
            List fields = ReflectionUtils.getAllDeclaredFields(controller.getClass());
            for (Field f : fields) {
                f.setAccessible(true);
                if (!f.isAnnotationPresent(BackgroundDisable.class)) continue;
                o = f.get(controller);
                if (o instanceof Node) {
                    n = (Node)o;
                    continue;
                }
                throw new RuntimeException("Field " + controller.getClass().getSimpleName() + "." + f.getName() + " annotated as @BackgroundDisable ");
            }
            for (Field f : fields) {
                if (!f.isAnnotationPresent(Background.class)) continue;
                o = f.get(controller);
                o = JavaFxRemoteServiceProxy.newAsynchProxy(o, n);
                f.set(controller, o);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

