/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.converter.string;

import com.anahata.jfx.bind.converter.Converter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractDateConverter
implements Converter<Date, String> {
    private DateFormat dateFormat = new SimpleDateFormat(this.getPattern());

    @Override
    public Date getAsDomainModelValue(Object node, String nodeModelValue) {
        if (nodeModelValue == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(nodeModelValue);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public String getAsNodeModelValue(Object node, Date domainModelValue) {
        if (domainModelValue == null) {
            return null;
        }
        return this.dateFormat.format(domainModelValue);
    }

    @Override
    public String format(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract String getPattern();
}

