/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.JfxUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.FileChooserBuilder;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);
    public static final String[] IMAGE_SUFFIXES;
    public static final List<String> IMAGE_EXTENSIONS;

    public static Group getOverLayedImage(Image base, Image overlay, int size, boolean fade, Pos position) {
        ImageView iconImageView = JfxUtils.makeIcon(base, size);
        return ImageUtils.getOverLayedImage((Node)iconImageView, overlay, size, 0, fade, position);
    }

    public static Group getOverLayedImage(Image base, Image overlay, int size, int spacing, boolean fade, Pos position) {
        ImageView iconImageView = JfxUtils.makeIcon(base, size);
        return ImageUtils.getOverLayedImage((Node)iconImageView, overlay, size, spacing, fade, position);
    }

    public static Group getOverLayedImage(Image base, Node overlay, int size, int spacing, boolean fade, Pos position) {
        SnapshotParameters sp = new SnapshotParameters();
        sp.setFill((Paint)Color.TRANSPARENT);
        return ImageUtils.getOverLayedImage(base, (Image)overlay.snapshot(sp, null), size, spacing, fade, position);
    }

    public static Group getOverLayedImage(Node base, Node overlay, int size, int spacing, boolean fade, Pos position) {
        SnapshotParameters sp = new SnapshotParameters();
        sp.setFill((Paint)Color.TRANSPARENT);
        return ImageUtils.getOverLayedImage(base, (Image)overlay.snapshot(sp, null), size, spacing, fade, position);
    }

    public static Group getOverLayedImage(Node base, Image overlay, int size, int spacing, boolean fade, Pos position) {
        Validate.notNull((Object)base);
        Validate.notNull((Object)overlay);
        Validate.notNull((Object)position);
        if (fade) {
            ColorAdjust colorAdjust = new ColorAdjust();
            colorAdjust.setBrightness(-0.3);
            colorAdjust.setSaturation(-0.3);
            base.setEffect((Effect)colorAdjust);
        }
        int overlayedImageSize = (int)((double)size / 1.75);
        ImageView overlayedImageView = new ImageView(overlay);
        overlayedImageView.setCache(true);
        overlayedImageView.setSmooth(true);
        overlayedImageView.setFitWidth((double)overlayedImageSize);
        overlayedImageView.setFitHeight((double)overlayedImageSize);
        if (position == Pos.CENTER_RIGHT) {
            overlayedImageView.setY((double)(size - overlayedImageSize / 2));
            overlayedImageView.setX((double)(size - overlayedImageSize + spacing));
        } else if (position == Pos.CENTER_LEFT) {
            overlayedImageView.setY((double)((size - overlayedImageSize) / 2));
            overlayedImageView.setX((double)(0 - (overlayedImageSize + spacing)));
        } else if (position == Pos.BOTTOM_RIGHT) {
            overlayedImageView.setX((double)(size - overlayedImageSize + spacing));
            overlayedImageView.setY((double)(size - overlayedImageSize + spacing));
        } else if (position == Pos.BOTTOM_LEFT) {
            overlayedImageView.setX((double)(0 - spacing));
            overlayedImageView.setY((double)(size - overlayedImageSize + spacing));
        } else {
            throw new UnsupportedOperationException("position " + position + " not yet implemented");
        }
        Group g = new Group();
        g.setBlendMode(BlendMode.SRC_OVER);
        g.getChildren().add((Object)base);
        g.getChildren().add((Object)overlayedImageView);
        return g;
    }

    public static File showOpenImageDialog(Window parent) {
        FileChooser fc = FileChooserBuilder.create().extensionFilters(new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Image Files", IMAGE_EXTENSIONS)}).title("Choose image").build();
        return fc.showOpenDialog(parent);
    }

    public static List<File> showOpenMultipleImageDialog(Window parent) {
        FileChooser fc = FileChooserBuilder.create().extensionFilters(new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Image Files", IMAGE_EXTENSIONS)}).title("Choose images").build();
        return fc.showOpenMultipleDialog(parent);
    }

    public static byte[] uploadImage(String message, ImageView imageView) {
        File f = ImageUtils.showOpenImageDialog(null);
        if (f != null) {
            try {
                byte[] uploadedLogo = FileUtils.readFileToByteArray((File)f);
                ObjectProperty userData = (ObjectProperty)imageView.getUserData();
                userData.setValue((Object)uploadedLogo);
                return uploadedLogo;
            }
            catch (Exception e) {
                log.error("Could not load logo", (Throwable)e);
            }
        }
        return null;
    }

    public static void initBindableImageView(final ImageView imageView, Label emptyImageLabel) {
        SimpleObjectProperty logoUserData = new SimpleObjectProperty();
        imageView.setUserData((Object)logoUserData);
        imageView.visibleProperty().bind((ObservableValue)imageView.imageProperty().isNotNull());
        logoUserData.addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                ObjectProperty userData = (ObjectProperty)imageView.getUserData();
                byte[] imageData = (byte[])userData.get();
                if (imageData != null) {
                    Image image = new Image((InputStream)new ByteArrayInputStream(imageData));
                    imageView.setSmooth(true);
                    imageView.setPreserveRatio(true);
                    imageView.setImage(image);
                } else {
                    imageView.setImage(null);
                }
            }
        });
        if (emptyImageLabel != null) {
            emptyImageLabel.visibleProperty().bind((ObservableValue)imageView.imageProperty().isNull());
        }
    }

    public static byte[] getUploadedImageData(ImageView imageView) {
        ObjectProperty sop = (ObjectProperty)imageView.getUserData();
        if (sop != null) {
            return (byte[])sop.get();
        }
        return null;
    }

    private ImageUtils() {
    }

    static {
        IMAGE_EXTENSIONS = new ArrayList<String>();
        for (String suffix : IMAGE_SUFFIXES = ImageIO.getReaderFileSuffixes()) {
            IMAGE_EXTENSIONS.add("*." + suffix.toUpperCase());
            IMAGE_EXTENSIONS.add("*." + suffix.toLowerCase());
        }
    }
}

