/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteTextField<T>
extends Control {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteTextField.class);
    private static final int DEFAULT_LIMIT = 0;
    private static final int DEFAULT_POPUP_SIZE = 6;
    private StringProperty text = new SimpleStringProperty();
    private final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private final IntegerProperty limit = new SimpleIntegerProperty(0);
    private final IntegerProperty popupSize = new SimpleIntegerProperty(6);
    private final IntegerProperty prefListWidth = new SimpleIntegerProperty();
    private final ObjectProperty<Pos> alignment = new SimpleObjectProperty();
    private final ObjectProperty<T> selectedItem = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty();
    private final IntegerProperty prefColumnCount = new SimpleIntegerProperty(12);
    private final StringProperty promptText = new SimpleStringProperty();
    private final ObjectProperty<DataFormatter<T>> dateFormatter = new SimpleObjectProperty(new DefaultDataFormatter());
    private final ObjectProperty<DataProvider<T>> dataProvider = new SimpleObjectProperty(null);
    private final ObjectProperty value = new SimpleObjectProperty();
    private ObjectProperty<Mode> mode = new SimpleObjectProperty((Object)Mode.STRING_ONLY);
    private BooleanProperty filterItems = new SimpleBooleanProperty(true);
    private BooleanProperty textFieldFocused = new SimpleBooleanProperty(false);
    private BooleanProperty dataProcessing = new SimpleBooleanProperty(false);
    private BooleanProperty singleMatchSelection = new SimpleBooleanProperty(false);
    private BooleanProperty showListOndata = new SimpleBooleanProperty(false);

    public AutoCompleteTextField() {
        this(Mode.STRING_ONLY);
    }

    public AutoCompleteTextField(Mode mode) {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName().toLowerCase());
        this.mode.set((Object)mode);
    }

    public boolean isFilterItems() {
        return this.filterItems.get();
    }

    public void setFilterItems(boolean b) {
        this.filterItems.setValue(Boolean.valueOf(b));
    }

    public boolean isSingleMatchSelection() {
        return this.singleMatchSelection.get();
    }

    public void setShowListOnData(boolean b) {
        this.showListOndata.setValue(Boolean.valueOf(b));
    }

    public boolean isShowListOnData() {
        return this.showListOndata.get();
    }

    public void setSingleMatchSelection(boolean b) {
        this.singleMatchSelection.setValue(Boolean.valueOf(b));
    }

    public ObjectProperty valueProperty() {
        return this.value;
    }

    public Object getValue() {
        return this.value.get();
    }

    public void setValue(Object o) {
        this.value.setValue(o);
    }

    public ObjectProperty modeProperty() {
        return this.mode;
    }

    public Mode getMode() {
        return (Mode)((Object)this.mode.get());
    }

    public void setMode(Mode mode) {
        this.mode.set((Object)mode);
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public BooleanProperty filterItemsProperty() {
        return this.filterItems;
    }

    public IntegerProperty limitProperty() {
        return this.limit;
    }

    public int getLimit() {
        return this.limit.get();
    }

    public void setLimit(int limit) {
        this.limit.set(limit);
    }

    public IntegerProperty popupSize() {
        return this.popupSize;
    }

    public int getPopupSize() {
        return this.popupSize.get();
    }

    public void setPopupSize(int popupSize) {
        this.popupSize.set(popupSize);
    }

    public ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.selectedItem;
    }

    public ObjectProperty<DataFormatter<T>> dataFormatterProperty() {
        return this.dateFormatter;
    }

    public DataFormatter<T> getDataFormatter() {
        return (DataFormatter)this.dateFormatter.get();
    }

    public GraphicDataFormatter<T> getGraphicDataFormatter() {
        return this.getDataFormatter() instanceof GraphicDataFormatter ? (GraphicDataFormatter)this.getDataFormatter() : null;
    }

    public void setDataFormatter(DataFormatter<T> dataToString) {
        this.dateFormatter.set(dataToString);
    }

    public StringProperty promptTextProperty() {
        return this.promptText;
    }

    public String getPromptText() {
        return (String)this.promptText.get();
    }

    public void setPromptText(String promptText) {
        this.promptText.set((Object)promptText);
    }

    public ObjectProperty<Pos> alignmentProperty() {
        return this.alignment;
    }

    public Pos getAlignment() {
        return (Pos)this.alignment.get();
    }

    public void setAlignment(Pos alignment) {
        this.alignment.set((Object)alignment);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public void setOnAction(EventHandler<ActionEvent> onAction) {
        this.onAction.set(onAction);
    }

    public IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public int getPrefColumnCount() {
        return this.prefColumnCount.get();
    }

    public void setPrefColumnCount(int prefColumnCount) {
        this.prefColumnCount.set(prefColumnCount);
    }

    public DataProvider<T> getDataProvider() {
        return (DataProvider)this.dataProvider.get();
    }

    public void setDataProvider(DataProvider<T> dp) {
        this.dataProvider.set(dp);
    }

    public ObjectProperty<DataProvider<T>> dataProviderProperty() {
        return this.dataProvider;
    }

    public BooleanProperty textFieldFocusedProperty() {
        return this.textFieldFocused;
    }

    public BooleanProperty dataProcessingProperty() {
        return this.dataProcessing;
    }

    public IntegerProperty prefListWidthProperty() {
        return this.prefListWidth;
    }

    public int getPrefListWidth() {
        return this.prefListWidth.getValue();
    }

    public void setPrefListWidth(int prefWidth) {
        this.prefListWidth.setValue((Number)prefWidth);
    }

    public ReadOnlyStringProperty textProperty() {
        return this.text;
    }

    public String getText() {
        return (String)this.text.get();
    }

    protected String getUserAgentStylesheet() {
        return "/com/anahata/jfx/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css";
    }

    public static final class DefaultDataFormatter<T>
    implements DataFormatter<T> {
        @Override
        public String toListViewString(T item) {
            return item == null ? null : item.toString();
        }

        @Override
        public String toTextFieldString(T item) {
            return item == null ? null : item.toString();
        }
    }

    public static interface GraphicDataFormatter<T>
    extends DataFormatter<T> {
        public Node getListViewGraphic(T var1);

        public Node toImageGraphic(T var1);

        public int getCellHeight();
    }

    public static interface DataFormatter<T> {
        public String toListViewString(T var1);

        public String toTextFieldString(T var1);
    }

    public static interface DataProvider<T> {
        public List<T> getData(String var1);

        public String getTaskMessage(String var1);
    }

    public static enum Mode {
        TYPED_ONLY,
        STRING_ONLY,
        MIXED;

    }
}

