/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.dialog;

import com.anahata.jfx.dialog.DialogOptions;
import com.anahata.jfx.dialog.DialogResources;
import javafx.scene.image.ImageView;

enum DialogType {
    ADVANCED_ERROR(DialogOptions.OK, "error48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Error";
        }
    }
    ,
    REPORT_ISSUE(DialogOptions.OK, "error48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Error";
        }
    }
    ,
    ERROR(DialogOptions.OK, "error48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Error";
        }
    }
    ,
    INFORMATION(DialogOptions.OK, "info48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Message";
        }
    }
    ,
    WARNING(DialogOptions.OK, "warning48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Warning";
        }
    }
    ,
    CONFIRMATION(DialogOptions.YES_NO_CANCEL, "confirm48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Select an Option";
        }
    }
    ,
    INPUT(DialogOptions.OK_CANCEL, "confirm48.image"){

        @Override
        public String getDefaultMasthead() {
            return "Select an Option";
        }
    };

    private final DialogOptions defaultOptions;
    private final String imageResource;

    private DialogType(DialogOptions defaultOptions, String imageResource) {
        this.defaultOptions = defaultOptions;
        this.imageResource = imageResource;
    }

    public ImageView getImage() {
        return DialogResources.getIcon(this.imageResource);
    }

    public String getDefaultTitle() {
        return this.getDefaultMasthead();
    }

    public abstract String getDefaultMasthead();

    public DialogOptions getDefaultOptions() {
        return this.defaultOptions;
    }
}

