/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.dialog;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.anahata.jfx.dialog.DialogResources;
import com.anahata.jfx.dialog.FXDialog;
import com.anahata.util.error.ErrorDetail;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabBuilder;
import javafx.scene.control.TabPane;
import javafx.scene.control.TabPaneBuilder;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBuilder;
import javafx.scene.control.TableViewBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextAreaBuilder;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.GridPaneBuilder;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.commons.lang3.exception.ExceptionUtils;

class AdvancedErrorDialog
extends FXDialog {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public AdvancedErrorDialog(Stage parent, ErrorDetail errorDetail) {
        super("Error Details");
        this.initModality(Modality.APPLICATION_MODAL);
        InetAddress localIpAddress = errorDetail.getLocalIpAddress();
        TabPane tabPane = TabPaneBuilder.create().tabs(new Tab[]{TabBuilder.create().text("Primary Details").closable(false).content((Node)ErrorGridPaneBuilder.create().row("Date / Time", DATE_FORMAT.format(errorDetail.getCreated())).row("Application", errorDetail.getApplicationName()).row("Version", errorDetail.getApplicationVersion()).row("Environment", errorDetail.getApplicationEnv().toString()).row("Device", errorDetail.getDevice()).row("Application User", errorDetail.getAppUserName()).row("Local IP Address", localIpAddress == null ? "" : localIpAddress.getHostAddress()).row("Local Host Name", localIpAddress == null ? "" : localIpAddress.getHostName()).row("External IP Address", errorDetail.getExternalIpAddress()).row("Java Vendor", errorDetail.getJavaVendor()).row("Java Version", errorDetail.getJavaVersion()).row("JavaFX Version", errorDetail.getJavaFxVersion()).row("OS Name", errorDetail.getOsName()).row("OS Version", errorDetail.getOsVersion()).row("OS Architecture", errorDetail.getOsArchitecture()).row("OS User", errorDetail.getUserName()).row("OS User Home Dir", errorDetail.getUserHome()).row("OS User Working Dir", errorDetail.getUserWorking()).row("User Comments", errorDetail.getUserComments()).build()).build()}).build();
        if (!errorDetail.getScreenshots().isEmpty()) {
            Tab tab = new Tab();
            tabPane.getTabs().add((Object)tab);
            tab.setText("Screenshots");
            tab.setClosable(false);
            ScrollPane sp = new ScrollPane();
            tab.setContent((Node)sp);
            VBox vb = new VBox();
            sp.setContent((Node)vb);
            for (byte[] barr : errorDetail.getScreenshots()) {
                vb.getChildren().add((Object)new ImageView(new Image((InputStream)new ByteArrayInputStream(barr))));
            }
        }
        if (errorDetail.getEvents() != null) {
            ObservableList events = FXCollections.observableArrayList((Collection)errorDetail.getEvents());
            tabPane.getTabs().add((Object)TabBuilder.create().text("Log Trace").closable(false).content((Node)((TableViewBuilder)TableViewBuilder.create().maxHeight(Double.MAX_VALUE)).columns(new TableColumn[]{TableColumnBuilder.create().text("Date / Time").prefWidth(140.0).cellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ILoggingEvent, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ILoggingEvent, String> p) {
                    return new ReadOnlyObjectWrapper((Object)DATE_FORMAT.format(new Date(((ILoggingEvent)p.getValue()).getTimeStamp())));
                }
            }).build(), TableColumnBuilder.create().text("Thread").prefWidth(200.0).cellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ILoggingEvent, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ILoggingEvent, String> p) {
                    return new ReadOnlyObjectWrapper((Object)((ILoggingEvent)p.getValue()).getThreadName());
                }
            }).build(), TableColumnBuilder.create().text("Level").prefWidth(50.0).cellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ILoggingEvent, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ILoggingEvent, String> p) {
                    return new ReadOnlyObjectWrapper((Object)((ILoggingEvent)p.getValue()).getLevel().toString());
                }
            }).build(), TableColumnBuilder.create().text("Logger").prefWidth(300.0).cellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ILoggingEvent, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ILoggingEvent, String> p) {
                    return new ReadOnlyObjectWrapper((Object)((ILoggingEvent)p.getValue()).getLoggerName());
                }
            }).build(), TableColumnBuilder.create().text("Message").prefWidth(1000.0).cellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ILoggingEvent, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ILoggingEvent, String> p) {
                    return new ReadOnlyObjectWrapper((Object)((ILoggingEvent)p.getValue()).getFormattedMessage());
                }
            }).build()}).items(events).build()).build());
            boolean tabCreated = false;
            TextArea textArea = ((TextAreaBuilder)TextAreaBuilder.create().editable(false)).build();
            for (ILoggingEvent event : errorDetail.getEvents()) {
                IThrowableProxy throwableProxy = event.getThrowableProxy();
                if (throwableProxy == null) continue;
                Throwable throwable = ((ThrowableProxy)throwableProxy).getThrowable();
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
                if (!tabCreated) {
                    tabCreated = true;
                    tabPane.getTabs().add((Object)TabBuilder.create().text("Exceptions").closable(false).content((Node)textArea).build());
                    textArea.textProperty().set((Object)stackTrace);
                    continue;
                }
                textArea.textProperty().set((Object)((String)textArea.textProperty().get() + "\n\n" + stackTrace));
            }
        }
        VBox contentPanel = ((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().styleClass(new String[]{"more-info-dialog"})).prefWidth(800.0)).prefHeight(600.0)).minHeight(Double.NEGATIVE_INFINITY)).spacing(8.0).children(new Node[]{tabPane, ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().styleClass(new String[]{"button-panel"})).children(new Node[]{((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text(DialogResources.getMessage("common.close.btn"))).prefWidth(80.0)).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                AdvancedErrorDialog.this.hide();
            }
        })).defaultButton(true).build()})).build()})).build();
        this.setContentPane((Pane)contentPanel);
    }

    private static class ErrorGridPaneBuilder {
        private GridPane gp = GridPaneBuilder.create().hgap(8.0).vgap(4.0).build();
        private int row = 1;

        private ErrorGridPaneBuilder() {
        }

        public static ErrorGridPaneBuilder create() {
            return new ErrorGridPaneBuilder();
        }

        public ErrorGridPaneBuilder row(String labelText, String value) {
            Label label = ((LabelBuilder)((LabelBuilder)LabelBuilder.create().text(labelText)).styleClass(new String[]{"error-label"})).build();
            this.gp.add((Node)label, 1, this.row);
            label = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().text(value)).styleClass(new String[]{"error-value"})).minWidth(Double.NEGATIVE_INFINITY)).minHeight(Double.NEGATIVE_INFINITY)).wrapText(true)).build();
            this.gp.add((Node)label, 2, this.row);
            ++this.row;
            return this;
        }

        public GridPane build() {
            return this.gp;
        }
    }
}

