/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.bind.nodemodel.NodeModel;
import com.anahata.jfx.internal.scene.control.skin.AutoCompleteComboBoxSkin;
import com.anahata.util.formatting.Displayable;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="items")
public class AutoCompleteComboBox<T>
extends ComboBoxBase<T>
implements NodeModel<AutoCompleteComboBox, Property> {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteComboBox.class);
    private static final String DEFAULT_STYLE_CLASS = "autocomplete-combo-box";
    private final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty<ObservableList<T>>(this, "items"){

        protected void invalidated() {
            if (AutoCompleteComboBox.this.getSkin() instanceof AutoCompleteComboBoxSkin) {
                AutoCompleteComboBoxSkin skin = (AutoCompleteComboBoxSkin)AutoCompleteComboBox.this.getSkin();
                skin.updateItems();
            }
        }
    };
    private final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final ObjectProperty<DataFilter<T>> dataFilter = new SimpleObjectProperty((Object)this, "filter");
    private final IntegerProperty visibleRowCount = new SimpleIntegerProperty((Object)this, "visibleRowCount", 10);
    private ObjectProperty<Node> placeholder;
    private final ObjectProperty<SingleSelectionModel<T>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<T>>(){

        protected void invalidated() {
            super.invalidated();
            SingleSelectionModel sm = (SingleSelectionModel)this.get();
            if (sm != null) {
                sm.selectedItemProperty().addListener(AutoCompleteComboBox.this.selectedItemListener);
            }
        }
    };
    private DoubleProperty prefListViewWidth;
    private TextField textField;
    private ReadOnlyObjectWrapper<TextInputControl> editor;
    private boolean block = false;
    private final InvalidationListener selectedItemListener = o -> {
        log.trace("invalidated");
        Object item = this.getSelectionModel().getSelectedItem();
        this.updateValue(item);
    };

    public AutoCompleteComboBox() {
        this(FXCollections.observableArrayList());
    }

    public AutoCompleteComboBox(ObservableList<T> items) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setItems(items);
        this.setEditable(true);
        this.init();
        this.initListeners();
    }

    private void init() {
        this.setDataFilter(new DefaultDataFilter());
        this.setSelectionModel(new AutoComboBoxSelectionModel(this));
    }

    private void initListeners() {
        this.valueProperty().addListener((ov, oldValue, newValue) -> {
            log.trace("valueChanged oldValue={} newValue={}", oldValue, newValue);
            if (this.getItems() == null) {
                return;
            }
            SingleSelectionModel<T> sm = this.getSelectionModel();
            int index = this.getItems().indexOf(newValue);
            log.trace("index= {}", (Object)index);
            if (index != -1) {
                sm.select(index);
            }
        });
    }

    public final void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setDataFilter(DataFilter<T> value) {
        this.dataFilterProperty().set(value);
    }

    public final DataFilter<T> getDataFilter() {
        return (DataFilter)this.dataFilterProperty().get();
    }

    public ObjectProperty<DataFilter<T>> dataFilterProperty() {
        return this.dataFilter;
    }

    public final void setVisibleRowCount(int value) {
        this.visibleRowCount.set(value);
    }

    public final int getVisibleRowCount() {
        return this.visibleRowCount.get();
    }

    public final IntegerProperty visibleRowCountProperty() {
        return this.visibleRowCount;
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty((Object)this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set((Object)node);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final ObjectProperty<SingleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final SingleSelectionModel<T> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final void setSelectionModel(SingleSelectionModel<T> value) {
        this.selectionModel.set(value);
    }

    public final void clearSelection() {
        log.trace("clearSelection");
        this.block = true;
        ((SingleSelectionModel)this.selectionModel.get()).clearSelection();
        this.block = false;
    }

    public final DoubleProperty prefListViewWidthProperty() {
        if (this.prefListViewWidth == null) {
            this.prefListViewWidth = new SimpleDoubleProperty((Object)this, "prefListViewWidth");
        }
        return this.prefListViewWidth;
    }

    public final double getPrefListViewWidth() {
        return this.prefListViewWidth == null ? -1.0 : this.prefListViewWidth.get();
    }

    public final void setPrefListViewWidth(double value) {
        this.prefListViewWidthProperty().set(value);
    }

    public final TextInputControl getEditor() {
        return (TextInputControl)this.editorProperty().get();
    }

    public final void setEditor(TextInputControl tic) {
        this.editorProperty();
        this.editor.set((Object)tic);
    }

    public final ReadOnlyObjectProperty<TextInputControl> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper((Object)this, "editor");
            this.textField = new AutoCompleteComboBoxSkin.FakeFocusTextField();
            this.editor.set((Object)this.textField);
        }
        return this.editor.getReadOnlyProperty();
    }

    @Override
    public Property getNodeModelValueProperty(AutoCompleteComboBox node) {
        return this.valueProperty();
    }

    protected String getUserAgentStylesheet() {
        return "/com/anahata/jfx/internal/scene/control/" + this.getClass().getSimpleName() + ".css";
    }

    private void updateValue(T item) {
        log.trace("combo updateValue={}", item);
        this.setValue(item);
    }

    public static <T> AutoCompleteComboBox<T> withTextArea() {
        log.debug("creating with text area.");
        AutoCompleteComboBox<T> combo = new AutoCompleteComboBox<T>();
        TextArea textArea = new TextArea();
        textArea.setWrapText(true);
        combo.setEditor((TextInputControl)textArea);
        return combo;
    }

    public static <T> void withTextAreaEditor(AutoCompleteComboBox<T> combo) {
        log.trace("creating with text area Editor.");
        TextArea textArea = new TextArea();
        textArea.setWrapText(true);
        textArea.getStyleClass().add((Object)"combo-editor");
        combo.setEditor((TextInputControl)textArea);
    }

    private static class DefaultDataFilter<T>
    implements DataFilter<T> {
        private DefaultDataFilter() {
        }

        @Override
        public boolean matches(T item, String text) {
            boolean match = false;
            if (item != null) {
                if (item instanceof Displayable) {
                    log.trace("DefaultDataFilter filtering displayable={}", item);
                    Displayable displayable = (Displayable)item;
                    match = StringUtils.containsIgnoreCase((CharSequence)displayable.getDisplayValue(), (CharSequence)text);
                } else {
                    log.trace("DefaultDataFilter filtering instance={}", item);
                    match = StringUtils.containsIgnoreCase((CharSequence)item.toString(), (CharSequence)text);
                }
            }
            return match;
        }
    }

    @FunctionalInterface
    public static interface DataFilter<T> {
        public boolean matches(T var1, String var2);
    }

    private class AutoComboBoxSelectionModel<T>
    extends SingleSelectionModel<T> {
        private final AutoCompleteComboBox<T> combo;

        public AutoComboBoxSelectionModel(AutoCompleteComboBox<T> combo) {
            Validate.notNull(combo, (String)"Combo cant be null.", (Object[])new Object[0]);
            this.combo = combo;
            this.selectedIndexProperty().addListener(o -> {
                log.trace("selectedIndex invalidated");
                if (!AutoCompleteComboBox.this.block) {
                    this.setSelectedItem(this.getModelItem(this.getSelectedIndex()));
                }
            });
        }

        protected T getModelItem(int index) {
            ObservableList<T> items = this.combo.getItems();
            if (items == null) {
                return null;
            }
            if (index < 0 || index >= items.size()) {
                return null;
            }
            return (T)items.get(index);
        }

        protected int getItemCount() {
            ObservableList<T> items = this.combo.getItems();
            return items == null ? 0 : items.size();
        }
    }
}

