/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.navigation;

import com.anahata.jfx.navigation.NavigationConfirmation;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Navigator
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Navigator.class);
    private Set<NavigationConfirmation> confirmations = new HashSet<NavigationConfirmation>();

    public void registerConfirmation(NavigationConfirmation confirmation) {
        Validate.notNull((Object)confirmation);
        this.confirmations.add(confirmation);
    }

    public void unregisterConfirmation(NavigationConfirmation confirmation) {
        Validate.notNull((Object)confirmation);
        this.confirmations.remove(confirmation);
    }

    public boolean canNavigate() {
        for (NavigationConfirmation confirmation : this.confirmations) {
            if (confirmation.canNavigateAway()) continue;
            return false;
        }
        return true;
    }
}

