/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.concurrent;

import com.anahata.jfx.concurrent.ApplicationTask;
import com.anahata.jfx.concurrent.BackgroundLoading;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;

public class BackgroundLoadingTask<T> {
    private BackgroundLoading<T> backgroundLoading;
    private Node node;
    private String message;
    private String title;
    private ApplicationTask task;

    public BackgroundLoadingTask(BackgroundLoading<T> backgroundLoading, Node node) {
        this(backgroundLoading, node, "Loading...");
    }

    public BackgroundLoadingTask(BackgroundLoading<T> backgroundLoading, Node node, String title) {
        this(backgroundLoading, node, title, null);
    }

    public BackgroundLoadingTask(BackgroundLoading<T> backgroundLoading, Node node, String title, String message) {
        this.backgroundLoading = backgroundLoading;
        this.node = node;
        this.message = message;
        this.title = title;
    }

    public void loadInBackground() {
        this.loadInBackground(true);
    }

    public void loadInBackground(boolean disableNodeWhileRunning) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new ApplicationTask<T>(){

            protected T call() throws Exception {
                this.updateTitle(BackgroundLoadingTask.this.title);
                this.updateMessage(BackgroundLoadingTask.this.message);
                if (BackgroundLoadingTask.this.task == this) {
                    return BackgroundLoadingTask.this.backgroundLoading.load();
                }
                this.cancel();
                return null;
            }

            protected void succeeded() {
                super.succeeded();
                if (BackgroundLoadingTask.this.task == this) {
                    BackgroundLoadingTask.this.backgroundLoading.loadSucceeded(super.getValue());
                }
            }

            protected void failed() {
                BackgroundLoadingTask.this.backgroundLoading.loadFailed(super.getException());
            }
        };
        if (disableNodeWhileRunning) {
            this.node.disableProperty().bind((ObservableValue)this.task.stateProperty().isNotEqualTo((Object)Worker.State.SUCCEEDED).and((ObservableBooleanValue)this.task.stateProperty().isNotEqualTo((Object)Worker.State.FAILED)));
        }
        this.task.launch();
    }
}

