/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.bind.BindUtils;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.TargetBean;
import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.converter.ConverterFactory;
import com.anahata.jfx.bind.filter.KeystrokeFilter;
import com.anahata.jfx.bind.nodemodel.ManualNodeModel;
import com.anahata.jfx.bind.nodemodel.NodeModel;
import com.anahata.jfx.bind.nodemodel.NodeModelFactory;
import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.message.JfxMessages;
import com.anahata.jfx.scene.control.AutoCompleteComboBox;
import com.anahata.jfx.scene.control.AutoCompleteTextField;
import com.anahata.jfx.scene.control.CalendarTextField;
import com.anahata.jfx.validator.FieldValidator;
import com.anahata.jfx.validator.FieldValidatorFactory;
import com.anahata.util.collections.ListUtils;
import com.anahata.util.lang.builder.DelimitedStringBuilder;
import com.anahata.util.metamodel.MetaModelProperty;
import com.anahata.util.metamodel.MetaModelUtils;
import com.anahata.util.model.ActivatableUtils;
import com.anahata.util.model.ActivePredicate;
import com.anahata.util.reflect.AnahataPropertyUtils;
import com.anahata.util.reflect.ReflectionUtils;
import com.anahata.util.validation.ConditionalValidation;
import com.anahata.util.validation.ValidationUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.ListExpression;
import javafx.beans.binding.SetExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.input.KeyEvent;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Binding {
    private static final Logger log = LoggerFactory.getLogger(Binding.class);
    private static final Logger blog = LoggerFactory.getLogger((String)(Binding.class.getName() + "#bind"));
    private static final Logger vlog = LoggerFactory.getLogger((String)(Binding.class.getName() + "#validate"));
    private static final Logger tlog = LoggerFactory.getLogger((String)(Binding.class.getName() + "#timing"));
    private Validator validator;
    private Object node;
    private Class nodeType;
    private TargetBean targetBean;
    private MetaModelProperty[] properties;
    private Class beanClass;
    private String propertyName;
    private Class propertyType;
    private javax.validation.metadata.PropertyDescriptor valPropDesc;
    private Converter converter;
    private KeystrokeFilter filter;
    private boolean writeable;
    private NodeModel nodeModel;
    private JfxMessages jfxMessages;
    private boolean childValidation;
    private boolean block = false;
    private BooleanProperty valid = new SimpleBooleanProperty(true);
    private Binder binder;
    private boolean observableList;
    private boolean collection;
    private boolean set;
    private boolean conditional;
    private FieldValidator fieldValidator;
    private boolean nodeIsBindForm;
    private BooleanProperty activeOnly = new SimpleBooleanProperty(false);
    private BooleanProperty inContext = new SimpleBooleanProperty();
    private String modelId;

    Binding(Binder binder, Validator validator, Object node, Class nodeGenericType, TargetBean targetBean, MetaModelProperty[] properties, Converter converter, KeystrokeFilter filter, JfxMessages jfxMessages, boolean readOnly, String modelId) {
        Validate.notNull((Object)binder);
        Validate.notNull((Object)validator);
        Validate.notNull((Object)node, (String)"bean attribute was null when binding %s.%s on bean %s; If the field is a JavaFX node, It should match the fx:id on the fxml if loading from FXML file. If the field is a JavaFX property or it is not loaded from fxml, then it should be programatically instantiated iether at the field level or on the init() method.", (Object[])new Object[]{properties[0].getDeclaringClass().getSimpleName(), properties[0].getName(), targetBean != null ? targetBean.getClass().getSimpleName() : " <null> "});
        Validate.notNull((Object)properties);
        Validate.notNull((Object)jfxMessages);
        Validate.notNull((Object)modelId);
        this.modelId = modelId;
        this.binder = binder;
        this.validator = validator;
        this.node = node;
        this.targetBean = targetBean;
        MetaModelProperty rootProp = properties[0];
        MetaModelProperty leafProp = properties[properties.length - 1];
        this.beanClass = rootProp.getDeclaringClass();
        this.propertyType = leafProp.getType();
        this.propertyName = MetaModelUtils.getNestedPropertyName((MetaModelProperty[])properties);
        this.filter = filter;
        PropertyDescriptor beanPropDesc = AnahataPropertyUtils.getPropertyDescriptor((Class)leafProp.getDeclaringClass(), (String)leafProp.getName());
        Validate.notNull((Object)beanPropDesc, (String)"Could not find property descriptor for leafProperty %s.%s. Most likely the metamodel object is in a stale state. Try a clean and build of the project containg the class %s and clean and build of the java-fx project", (Object[])new Object[]{leafProp.getDeclaringClass(), leafProp.getName(), this.beanClass});
        this.writeable = beanPropDesc.getWriteMethod() != null && !readOnly;
        BeanDescriptor valBeanDesc = validator.getConstraintsForClass(this.beanClass);
        this.valPropDesc = valBeanDesc.getConstraintsForProperty(leafProp.getName());
        this.jfxMessages = jfxMessages;
        this.childValidation = this.valPropDesc != null && this.valPropDesc.isCascaded();
        this.conditional = ConditionalValidation.class.isAssignableFrom(this.beanClass);
        this.nodeModel = NodeModelFactory.getNodeModel(node);
        if (this.nodeModel == null) {
            throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
        }
        this.refreshContext();
        this.targetBean.getBean().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                Binding.this.refreshContext();
            }
        });
        if (this.valPropDesc != null && node instanceof Node) {
            for (ConstraintDescriptor cd : this.valPropDesc.getConstraintDescriptors()) {
                if (!this.isRequiredValidation(cd.getAnnotation())) continue;
                Node n = (Node)node;
                n.getStyleClass().add((Object)"requiredField");
                break;
            }
        }
        Object value = this.nodeModel.getNodeModelValueProperty(node);
        Validate.notNull(value, (String)"nodeMode %s returned null value Property for node %s", (Object[])new Object[]{this.nodeModel, node});
        this.nodeIsBindForm = BindUtils.isBindForm(node);
        if (this.writeable) {
            if (value instanceof ObservableList) {
                ObservableList list = (ObservableList)value;
                list.addListener((ListChangeListener)new ListPropertyChangeListener());
            } else if (value instanceof ObservableSet) {
                ObservableSet oset = (ObservableSet)value;
                oset.addListener((SetChangeListener)new SetPropertyChangeListener());
            } else if (!this.nodeIsBindForm) {
                Control n;
                value.addListener((ChangeListener)new PropertyChangeListener());
                if (node instanceof CalendarTextField) {
                    n = (CalendarTextField)node;
                    n.textFieldFocusedProperty().addListener((ChangeListener)new FocusListener());
                } else if (node instanceof DatePicker) {
                    DatePicker dp = (DatePicker)node;
                    dp.focusedProperty().addListener((ChangeListener)new FocusListener());
                } else if (node instanceof AutoCompleteComboBox) {
                    AutoCompleteComboBox cb = (AutoCompleteComboBox)node;
                    cb.getEditor().focusedProperty().addListener((ChangeListener)new FocusListener());
                } else if (node instanceof AutoCompleteTextField) {
                    n = (AutoCompleteTextField)((Object)node);
                    n.textFieldFocusedProperty().addListener((ChangeListener)new FocusListener());
                } else if (node instanceof Node) {
                    n = (Node)node;
                    n.focusedProperty().addListener((ChangeListener)new FocusListener());
                }
            }
            if (filter != null && node instanceof Node) {
                ((Node)node).addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new StringControlFilter());
            }
        }
        Class[] args = ReflectionUtils.getGenericArgs(Property.class, value.getClass());
        Validate.notNull((Object)args, (String)"Could not get generic args for the node model of property %s", (Object[])new Object[]{this.propertyName});
        Validate.isTrue((args.length == 1 ? 1 : 0) != 0, (String)"Invalid generic args for the node model of property %s, required only 1, had %d", (Object[])new Object[]{this.propertyName, args.length});
        this.nodeType = args[0];
        if (Object.class.equals((Object)this.nodeType) && nodeGenericType != null) {
            this.nodeType = nodeGenericType;
        }
        this.converter = converter == null ? ConverterFactory.getDefaultConverter(this.propertyType, this.nodeType) : converter;
        this.observableList = Collection.class.isAssignableFrom(this.propertyType) && value instanceof ObjectProperty;
        this.collection = Collection.class.isAssignableFrom(this.propertyType) && value instanceof ListExpression;
        this.set = Set.class.isAssignableFrom(this.propertyType) && value instanceof SetExpression;
        this.fieldValidator = FieldValidatorFactory.getFieldValidator(this.propertyType);
    }

    BooleanProperty validProperty() {
        return this.valid;
    }

    boolean isInContext() {
        this.refreshContext();
        return this.inContext.get();
    }

    BooleanProperty inContextProperty() {
        return this.inContext;
    }

    void bindFromModel(Object ... excludeNodes) {
        if (this.targetBean.getBean().getValue() == null || this.block) {
            return;
        }
        if (!this.isInContext()) {
            blog.debug("MODEL -> UI: {}.{} Not binding as target bean class not compatible: {}", new Object[]{this.beanClass.getSimpleName(), this.propertyName, this.targetBean.getBean().get().getClass().getSimpleName()});
            return;
        }
        this.block = true;
        Object modelValue = this.getModelValue();
        blog.debug("MODEL -> UI: {}.{}={} bean identityHashCode={} value identityHashCode={}", new Object[]{this.beanClass.getSimpleName(), this.propertyName, modelValue, System.identityHashCode(this.targetBean.getBean()), System.identityHashCode(modelValue)});
        if (this.nodeIsBindForm) {
            BindUtils.getBindForm(this.node).setExcludeNodes(excludeNodes);
        }
        if (this.observableList) {
            if (this.nodeModel instanceof ManualNodeModel) {
                Collection coll = (Collection)modelValue;
                ManualNodeModel mnm = (ManualNodeModel)this.nodeModel;
                mnm.setValue(this.node, this.activeOnly.get() ? ActivePredicate.list((Collection)coll) : coll);
            } else {
                List modelList;
                ObjectProperty value = (ObjectProperty)this.nodeModel.getNodeModelValueProperty(this.node);
                ObservableList list = (ObservableList)value.get();
                if (list == null) {
                    list = FXCollections.observableArrayList();
                    value.set((Object)list);
                }
                if ((modelList = (List)modelValue) == null) {
                    list.clear();
                } else if (this.activeOnly.get()) {
                    ListUtils.setAll((List)list, (List)ActivePredicate.list((Collection)modelList));
                } else {
                    ListUtils.setAll((List)list, (List)modelList);
                }
            }
        } else if (this.collection) {
            if (this.nodeModel instanceof ManualNodeModel) {
                Collection coll = (Collection)modelValue;
                ManualNodeModel mnm = (ManualNodeModel)this.nodeModel;
                mnm.setValue(this.node, this.activeOnly.get() ? ActivePredicate.list((Collection)coll) : coll);
            } else {
                List modelList;
                ListPropertyBase value = (ListPropertyBase)this.nodeModel.getNodeModelValueProperty(this.node);
                ObservableList list = value.get();
                if (list == null) {
                    list = FXCollections.observableArrayList();
                    value.set(list);
                }
                if ((modelList = (List)modelValue) == null) {
                    list.clear();
                } else if (this.activeOnly.get()) {
                    ListUtils.setAll((List)list, (List)ActivePredicate.list((Collection)modelList));
                } else {
                    ListUtils.setAll((List)list, (List)modelList);
                }
            }
        } else if (this.set) {
            SetPropertyBase value = (SetPropertyBase)this.nodeModel.getNodeModelValueProperty(this.node);
            ObservableSet oset = value.get();
            if (oset == null) {
                oset = FXCollections.observableSet((Object[])new Object[0]);
                value.set(oset);
            }
            Set currSet = (Set)modelValue;
            oset.clear();
            if (currSet != null) {
                if (this.activeOnly.get()) {
                    oset.addAll((Collection)ActivePredicate.list((Collection)currSet));
                } else {
                    oset.addAll((Collection)currSet);
                }
            }
        } else {
            try {
                this.nodeModel.getNodeModelValueProperty(this.node).setValue(modelValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception binding " + this.propertyName + " from model", e);
            }
        }
        this.block = false;
    }

    void clearMessages() {
        if (this.block) {
            return;
        }
        this.valid.set(true);
        this.binder.setValid(this.propertyName);
        if (this.node instanceof Node) {
            this.jfxMessages.clearMessage((Node)this.node);
        }
    }

    void validate(boolean publishError) {
        long ts1 = System.currentTimeMillis();
        if (this.block) {
            vlog.debug("{}.{} Exiting due to blocked", (Object)this.beanClass.getSimpleName(), (Object)this.propertyName);
            return;
        }
        if (this.targetBean.getBean().getValue() == null) {
            vlog.debug("{}.{} Exiting due to null targetBean value", (Object)this.beanClass.getSimpleName(), (Object)this.propertyName);
            return;
        }
        if (!this.isInContext()) {
            vlog.debug("{}.{} Not validating as target bean class not compatible: {}", new Object[]{this.beanClass.getSimpleName(), this.propertyName, this.targetBean.getBean().get().getClass().getSimpleName()});
            return;
        }
        if (this.nodeIsBindForm && !this.childValidation) {
            vlog.debug("{}.{} Exiting due to BindForm without child validation,", (Object)this.beanClass.getSimpleName(), (Object)this.propertyName);
            return;
        }
        Object value = this.targetBean.getBean().getValue();
        if (ActivatableUtils.isInactive((Object)value)) {
            vlog.debug("{}.{} Exiting due to inactive", (Object)this.beanClass.getSimpleName(), (Object)this.propertyName);
            this.clearMessages();
            return;
        }
        vlog.debug("{}.{} Validating", (Object)this.beanClass.getSimpleName(), (Object)this.propertyName);
        Class[] standardGroups = ValidationUtils.getValidationGroups((Object)value);
        HashSet otherGroups = new HashSet();
        for (Class<?> group : this.binder.getValidations()) {
            if (!this.binder.getValidationActive(group).get()) continue;
            otherGroups.add(group);
        }
        HashSet groups = new HashSet();
        groups.addAll(Arrays.asList(standardGroups));
        groups.addAll(otherGroups);
        Class[] groupsArray = new Class[groups.size()];
        groupsArray = groups.toArray(groupsArray);
        HashSet<Object> cvs = new HashSet<Object>();
        Set<ConstraintViolation<Object>> classViolations = this.targetBean.validate(groupsArray);
        long ts2 = System.currentTimeMillis();
        tlog.trace("initial validation = {} ms", (Object)(ts2 - ts1));
        if (this.binder.getParentBinding() != null) {
            Object parentTargetBean = this.binder.getParentBinding().getTargetBean().getBean().get();
            if (parentTargetBean != null) {
                Set<ConstraintViolation<Object>> set = this.binder.getParentBinding().getTargetBean().validate(groupsArray);
                for (ConstraintViolation<Object> constraintViolation : set) {
                    if (!ActivatableUtils.isActive((Object)constraintViolation.getLeafBean())) continue;
                    String valPropName = ValidationUtils.getValidationPropertyName(constraintViolation);
                    String firstProp = StringUtils.substringBefore((String)valPropName, (String)".");
                    Iterator lastProp = StringUtils.substringAfterLast((String)valPropName, (String)".");
                    if (!firstProp.equals(this.binder.getParentBinding().getPropertyName()) || !((String)((Object)lastProp)).equals(this.propertyName)) continue;
                    cvs.add(constraintViolation);
                }
            }
            tlog.trace("parent validation = {} ms", (Object)(System.currentTimeMillis() - ts2));
        }
        for (ConstraintViolation constraintViolation : classViolations) {
            if (!ActivatableUtils.isActive((Object)constraintViolation.getLeafBean())) continue;
            String valPropName = ValidationUtils.getValidationPropertyName((ConstraintViolation)constraintViolation);
            String string = StringUtils.substringBefore((String)valPropName, (String)".");
            if (!Objects.equals(this.propertyName, valPropName) && !Objects.equals(this.propertyName, string)) continue;
            cvs.add(constraintViolation);
        }
        this.binder.setValid(this.propertyName);
        for (Class clazz : groups) {
            if (Default.class.equals((Object)clazz)) continue;
            this.binder.setValid(this.propertyName, clazz);
        }
        HashSet<Node> valNodes = new HashSet<Node>();
        if (!cvs.isEmpty()) {
            boolean bl;
            if (vlog.isDebugEnabled()) {
                vlog.debug("Validation errors ({}) for {} {}.{} {}:", new Object[]{publishError ? "published" : "unpublished", this.objectToString(this.node), this.beanClass.getSimpleName(), this.propertyName, this.targetBean.getBean().get().toString()});
            }
            boolean bl2 = false;
            for (ConstraintViolation constraintViolation : cvs) {
                Set cvGroups = constraintViolation.getConstraintDescriptor().getGroups();
                if (vlog.isDebugEnabled()) {
                    DelimitedStringBuilder sb = new DelimitedStringBuilder(", ");
                    for (Class group : cvGroups) {
                        sb.append(group.getSimpleName());
                    }
                    vlog.debug("  Root={} Leaf={} Path={} Groups={} Message={}", new Object[]{constraintViolation.getRootBeanClass().getName(), constraintViolation.getLeafBean().getClass().getName(), constraintViolation.getPropertyPath(), sb.toString(), constraintViolation.getMessage()});
                }
                HashSet tgroups = new HashSet(groups);
                for (Class group : tgroups) {
                    if (!cvGroups.contains(group)) continue;
                    if (Default.class.equals((Object)group)) {
                        this.binder.setInvalid(this.propertyName);
                        this.valid.set(false);
                    } else {
                        this.binder.setInvalid(this.propertyName, group);
                    }
                    bl = true;
                    groups.remove(group);
                }
            }
            long ts3 = System.currentTimeMillis();
            if (bl && publishError && (!this.nodeIsBindForm || BindUtils.getBindForm(this.node).showContainerErrors().get())) {
                Node valNode = this.node instanceof Node ? (Node)this.node : null;
                for (ConstraintViolation cv : cvs) {
                    this.jfxMessages.addMessage(this.binder.getView(this), valNode, JfxMessage.error(cv.getMessage()));
                    valNodes.add(valNode);
                }
            }
            tlog.trace("publishing of error = {} ms", (Object)(System.currentTimeMillis() - ts3));
        } else {
            long l = System.currentTimeMillis();
            this.clearMessages();
            tlog.trace("Clearing of messages = {} ms", (Object)(System.currentTimeMillis() - l));
        }
        if (this.node instanceof Node && valNodes.isEmpty() && publishError) {
            vlog.debug("Clearing message for {} {}.{}", new Object[]{this.objectToString(this.node), this.beanClass.getSimpleName(), this.propertyName});
            this.jfxMessages.clearMessage((Node)this.node);
        }
        long l = System.currentTimeMillis();
        tlog.trace("total time = {} ms", (Object)(l - ts1));
    }

    BooleanProperty activeOnlyProperty() {
        return this.activeOnly;
    }

    private <T> T getModelValue() {
        Object value;
        try {
            value = PropertyUtils.getProperty((Object)this.targetBean.getBean().getValue(), (String)this.propertyName);
        }
        catch (NestedNullException e) {
            value = null;
        }
        catch (NoSuchMethodException e) {
            log.info("Could not fetch property {} due to NoSuchMethodException", (Object)this.propertyName);
            value = null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Exception fetching property " + this.propertyName + " from model on bean: " + this.targetBean.getBean().getValue(), e);
        }
        if (this.converter != null) {
            try {
                value = this.converter.getAsNodeModelValue(this.node, value);
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception converting model value to node value for : " + this.propertyName, e);
            }
        }
        return (T)value;
    }

    private Object prepareModelValue(Object value) {
        if (this.converter != null) {
            value = this.converter.getAsDomainModelValue(this.node, value);
        }
        return value;
    }

    private void setInvalidWarn(String message) {
        this.jfxMessages.addMessage(this.binder.getView(this), (Node)this.node, JfxMessage.warn(message));
    }

    private boolean isRequiredValidation(Annotation annotation) {
        return annotation instanceof NotNull || annotation instanceof NotEmpty || annotation instanceof NotBlank;
    }

    private String objectToString(Object obj) {
        Node n;
        if (obj == null) {
            return "{null}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getSimpleName());
        if (obj instanceof Node && !StringUtils.isBlank((CharSequence)(n = (Node)obj).getId())) {
            sb.append("[id=");
            sb.append(n.getId());
            sb.append("]");
        }
        return sb.toString();
    }

    private void refreshContext() {
        this.inContext.set(this.targetBean.getBean().get() != null ? this.beanClass.isAssignableFrom(this.targetBean.getBean().get().getClass()) : false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Binding)) {
            return false;
        }
        Binding other = (Binding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$node = this.getNode();
        Object other$node = other.getNode();
        return !(this$node == null ? other$node != null : !this$node.equals(other$node));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Binding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $node = this.getNode();
        result = result * 59 + ($node == null ? 0 : $node.hashCode());
        return result;
    }

    Validator getValidator() {
        return this.validator;
    }

    Object getNode() {
        return this.node;
    }

    Class getNodeType() {
        return this.nodeType;
    }

    TargetBean getTargetBean() {
        return this.targetBean;
    }

    MetaModelProperty[] getProperties() {
        return this.properties;
    }

    Class getBeanClass() {
        return this.beanClass;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    Class getPropertyType() {
        return this.propertyType;
    }

    javax.validation.metadata.PropertyDescriptor getValPropDesc() {
        return this.valPropDesc;
    }

    Converter getConverter() {
        return this.converter;
    }

    KeystrokeFilter getFilter() {
        return this.filter;
    }

    boolean isWriteable() {
        return this.writeable;
    }

    NodeModel getNodeModel() {
        return this.nodeModel;
    }

    JfxMessages getJfxMessages() {
        return this.jfxMessages;
    }

    boolean isChildValidation() {
        return this.childValidation;
    }

    boolean isBlock() {
        return this.block;
    }

    BooleanProperty getValid() {
        return this.valid;
    }

    boolean isObservableList() {
        return this.observableList;
    }

    boolean isCollection() {
        return this.collection;
    }

    boolean isSet() {
        return this.set;
    }

    boolean isConditional() {
        return this.conditional;
    }

    FieldValidator getFieldValidator() {
        return this.fieldValidator;
    }

    boolean isNodeIsBindForm() {
        return this.nodeIsBindForm;
    }

    BooleanProperty getActiveOnly() {
        return this.activeOnly;
    }

    BooleanProperty getInContext() {
        return this.inContext;
    }

    String getModelId() {
        return this.modelId;
    }

    public Binder getBinder() {
        return this.binder;
    }

    private class SetPropertyChangeListener
    implements SetChangeListener {
        private SetPropertyChangeListener() {
        }

        public void onChanged(SetChangeListener.Change change) {
            if (!Binding.this.isInContext() || Binding.this.block || Binding.this.binder.isBlock() || Binding.this.binder.getBindingPhase() == Binder.BindingPhase.BIND_FROM_MODEL) {
                return;
            }
            HashSet set = new HashSet(change.getSet());
            blog.debug("UI -> MODEL: {}.{} = {}", new Object[]{Binding.this.beanClass.getSimpleName(), Binding.this.propertyName, set});
            if (!AnahataPropertyUtils.setPropertyNulls((Object)Binding.this.targetBean.getBean().getValue(), (String)Binding.this.propertyName, set)) {
                blog.info("Nested null encountered for {}.{}", (Object)Binding.this.beanClass.getSimpleName(), (Object)Binding.this.propertyName);
            }
            Binding.this.binder.getRootBinder().setValidationRequired();
            Binding.this.validate(true);
            Binding.this.binder.setFormModified(Binding.this);
        }
    }

    private class ListPropertyChangeListener
    implements ListChangeListener {
        private ListPropertyChangeListener() {
        }

        public void onChanged(ListChangeListener.Change change) {
            if (!Binding.this.isInContext() || Binding.this.block || Binding.this.binder.isBlock() || Binding.this.binder.getBindingPhase() == Binder.BindingPhase.BIND_FROM_MODEL) {
                return;
            }
            ArrayList list = new ArrayList(change.getList());
            blog.debug("UI -> MODEL: {}.{} = {}", new Object[]{Binding.this.beanClass.getSimpleName(), Binding.this.propertyName, list});
            if (!AnahataPropertyUtils.setPropertyNulls((Object)Binding.this.targetBean.getBean().getValue(), (String)Binding.this.propertyName, list)) {
                blog.info("Nested null encountered for {}.{}", (Object)Binding.this.beanClass.getSimpleName(), (Object)Binding.this.propertyName);
            }
            Binding.this.binder.getRootBinder().setValidationRequired();
            Binding.this.validate(true);
            Binding.this.binder.setFormModified(Binding.this);
        }
    }

    private class FocusListener
    implements ChangeListener<Boolean> {
        private FocusListener() {
        }

        public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
            if (!Binding.this.isInContext() || Binding.this.block || Binding.this.binder.isBlock() || Binding.this.binder.getBindingPhase() == Binder.BindingPhase.BIND_FROM_MODEL) {
                return;
            }
            if (newValue.booleanValue()) {
                log.debug("Gaining focus to field {}", Binding.this.node);
                if (Binding.this.node instanceof Node) {
                    log.debug("Requesting focus to field {}", Binding.this.node);
                    Binding.this.getBinder().getRootBinder().setFocusedField((Node)Binding.this.node);
                } else {
                    log.debug("Not requesting focus to field {}", Binding.this.node);
                }
            } else {
                Set cvs;
                boolean hasViolation = false;
                Object modelValue = Binding.this.targetBean.getBean().getValue();
                if (!ActivatableUtils.isInactive((Object)modelValue) && !(cvs = Binding.this.validator.validate(modelValue, ValidationUtils.getValidationGroups((Object)modelValue))).isEmpty()) {
                    for (ConstraintViolation cv : cvs) {
                        if (!StringUtils.isBlank((CharSequence)cv.getPropertyPath().toString())) continue;
                        hasViolation = true;
                        Binding.this.jfxMessages.addMessage(Binding.this.binder.getView(Binding.this), null, JfxMessage.error(cv.getMessage()));
                    }
                }
                if (hasViolation) {
                    Binding.this.binder.setGlobalInvalid();
                } else {
                    Binding.this.binder.setGlobalValid();
                    Binding.this.jfxMessages.clearIdMessages();
                }
                Binding.this.bindFromModel(new Object[0]);
            }
        }
    }

    private class PropertyChangeListener
    implements ChangeListener {
        private PropertyChangeListener() {
        }

        public void changed(ObservableValue ov, Object oldValue, Object newValue) {
            String message;
            long ts1 = System.currentTimeMillis();
            if (!Binding.this.isInContext() || Binding.this.block || Binding.this.binder.isBlock() || Binding.this.binder.getBindingPhase() == Binder.BindingPhase.BIND_FROM_MODEL) {
                return;
            }
            if (Binding.this.fieldValidator != null && newValue instanceof String && (message = Binding.this.fieldValidator.validate((String)newValue)) != null) {
                Binding.this.valid.set(false);
                Binding.this.binder.setInvalid(Binding.this.propertyName);
                Binding.this.jfxMessages.addMessage(Binding.this.binder.getView(Binding.this), (Node)Binding.this.node, JfxMessage.error(message));
                return;
            }
            long ts2 = System.currentTimeMillis();
            Object value = Binding.this.prepareModelValue(newValue);
            blog.debug("UI -> MODEL: {}.{} = {}", new Object[]{Binding.this.beanClass.getSimpleName(), Binding.this.propertyName, value != null && value instanceof byte[] ? "byte[].length=" + ((byte[])value).length : value});
            if (!AnahataPropertyUtils.setPropertyNulls((Object)Binding.this.targetBean.getBean().getValue(), (String)Binding.this.propertyName, (Object)value)) {
                blog.info("Nested null encountered for {}.{}", (Object)Binding.this.beanClass.getSimpleName(), (Object)Binding.this.propertyName);
            }
            long ts3 = System.currentTimeMillis();
            tlog.trace("changed: setting time={} ms", (Object)(ts3 - ts2));
            blog.debug("Setting validation on rootBinder.controller={}", (Object)Binding.this.binder.getRootBinder().getController().getClass().getSimpleName());
            Binding.this.binder.getRootBinder().setValidationRequired();
            Binding.this.validate(true);
            long ts4 = System.currentTimeMillis();
            tlog.trace("changed: validation={} ms", (Object)(ts4 - ts3));
            Binding.this.block = true;
            Binding.this.binder.setFormModified(Binding.this);
            Binding.this.block = false;
            tlog.trace("changed: bind from model={} ms", (Object)(System.currentTimeMillis() - ts4));
            tlog.trace("changed: RETURNING, elapsed={} ms", (Object)(System.currentTimeMillis() - ts1));
        }
    }

    private class StringControlFilter
    implements EventHandler<KeyEvent> {
        private StringControlFilter() {
        }

        public void handle(KeyEvent keyEvent) {
            String message;
            boolean defined;
            if (!Binding.this.isInContext()) {
                return;
            }
            char c = keyEvent.getCharacter().charAt(0);
            boolean bl = defined = Character.isDefined(c) && c != '\b' && c != '\t';
            if (!(!defined || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown() || keyEvent.isShortcutDown() || (message = Binding.this.filter.filterKeystrokes(keyEvent.getCharacter())) == null)) {
                keyEvent.consume();
                Binding.this.setInvalidWarn(message);
            }
        }
    }
}

