/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.CdiControllerFactory;
import com.anahata.jfx.fxml.FXMLController;
import com.anahata.util.awt.AWTUtils;
import com.anahata.util.cdi.Cdi;
import com.sun.javafx.robot.impl.FXRobotHelper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Control;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JfxUtils {
    private static final Logger log = LoggerFactory.getLogger(JfxUtils.class);
    private static final String PATH_PREFIX = "/fxml";

    public static FXMLLoader loader(String path) {
        return JfxUtils.loader(path, null);
    }

    public static FXMLLoader loader(String path, ResourceBundle resources) {
        Validate.notNull((Object)path, (String)"The path is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)path.startsWith("/"), (String)"The path must begin with a slash", (Object[])new Object[0]);
        String fullPath = PATH_PREFIX + path;
        URL url = JfxUtils.class.getResource(fullPath);
        Validate.notNull((Object)url, (String)"Could not locate fxml with path %s", (Object[])new Object[]{fullPath});
        log.debug("loading from URL {} ", (Object)url);
        FXMLLoader loader = new FXMLLoader(url, resources);
        loader.setControllerFactory((Callback)CdiControllerFactory.INSTANCE);
        return loader;
    }

    public static FXMLLoader load(String path) {
        try {
            FXMLLoader loader = JfxUtils.loader(path);
            loader.load();
            return loader;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FXMLLoader load(Class<?> controllerClass) {
        try {
            FXMLController fxmlController = controllerClass.getAnnotation(FXMLController.class);
            Validate.notNull((Object)fxmlController, (String)("Could not find FXMLController annotation on class " + controllerClass.getName()), (Object[])new Object[0]);
            String path = fxmlController.value();
            Validate.notNull((Object)path, (String)"The path is required", (Object[])new Object[0]);
            Validate.isTrue((boolean)path.startsWith("/"), (String)"The path must begin with a slash", (Object[])new Object[0]);
            String fullPath = PATH_PREFIX + path;
            URL url = JfxUtils.class.getResource(fullPath);
            Validate.notNull((Object)url, (String)"Could not locate fxml with path %s", (Object[])new Object[]{fullPath});
            log.debug("loading from URL {} ", (Object)url);
            FXMLLoader loader = new FXMLLoader(url);
            loader.setControllerFactory((Callback)CdiControllerFactory.INSTANCE);
            loader.load();
            return loader;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadControl(String path, Node root, Class<T> controllerClass) {
        Validate.notNull((Object)path);
        Validate.notNull((Object)root);
        Validate.notNull(controllerClass);
        FXMLLoader loader = JfxUtils.loader(path);
        loader.setRoot((Object)root);
        Object controller = Cdi.get(controllerClass, (Annotation[])new Annotation[0]);
        loader.setController(controller);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)controller;
    }

    public static ImageView makeImageView(String path) {
        Validate.notNull((Object)path);
        ImageView iv = new ImageView();
        Image i = new Image(JfxUtils.class.getResource(path).toString());
        iv.setImage(i);
        return iv;
    }

    public static List<byte[]> snapshotAllStages() {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (Stage s : FXRobotHelper.getStages()) {
            ret.add(JfxUtils.snapshot((Node)s.getScene().getRoot()));
        }
        return ret;
    }

    public static byte[] snapshot(Node node) {
        SnapshotParameters sp = new SnapshotParameters();
        sp.setFill((Paint)Color.TRANSPARENT);
        WritableImage snapshot = node.snapshot(sp, null);
        BufferedImage fromFXImage = SwingFXUtils.fromFXImage((Image)snapshot, null);
        byte[] result = AWTUtils.toPNG((BufferedImage)fromFXImage);
        log.debug("snapshot: Returning image size={}", (Object)result.length);
        return result;
    }

    public static void showTooltipRightOfControl(Control control, Tooltip tooltip) {
        Point2D p = control.localToScene(0.0, 0.0);
        Tooltip.install((Node)control, (Tooltip)tooltip);
        tooltip.setAutoFix(true);
        tooltip.show((Node)control, p.getX() + control.getScene().getX() + control.getScene().getWindow().getX() + control.getWidth(), p.getY() + control.getScene().getY() + control.getScene().getWindow().getY());
    }

    public static void ensureFXThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAndWait(final Runnable run) throws InterruptedException, ExecutionException {
        if (Platform.isFxApplicationThread()) {
            try {
                run.run();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        final ReentrantLock lock = new ReentrantLock();
        final Condition condition = lock.newCondition();
        final ThrowableWrapper throwableWrapper = new ThrowableWrapper();
        lock.lock();
        try {
            Platform.runLater((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    lock.lock();
                    try {
                        run.run();
                    }
                    catch (Throwable e) {
                        throwableWrapper.t = e;
                    }
                    finally {
                        try {
                            condition.signal();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            });
            condition.await();
            if (throwableWrapper.t != null) {
                throw new ExecutionException(throwableWrapper.t);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static ImageView makeIcon(Image image, int maxSize) {
        Validate.notNull((Object)image);
        ImageView iv = new ImageView(image);
        iv.setFitHeight((double)maxSize);
        iv.setFitWidth((double)maxSize);
        iv.setCache(true);
        iv.setPreserveRatio(true);
        iv.setSmooth(true);
        return iv;
    }

    public static Image makeImage(byte[] image) {
        if (image == null) {
            return null;
        }
        Image i = new Image((InputStream)new ByteArrayInputStream(image));
        return i;
    }

    public static <T> T findParent(Node n, Class<T> parentType) {
        Parent p;
        for (p = n.getParent(); p != null && !parentType.isAssignableFrom(p.getClass()); p = p.getParent()) {
        }
        return (T)p;
    }

    public static boolean isInAncestor(Node child, Node ancestor) {
        Validate.notNull((Object)child);
        Validate.notNull((Object)ancestor);
        for (Parent parent = child.getParent(); parent != null; parent = parent.getParent()) {
            if (!ancestor.equals(parent)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void bindDisplayed(Node node, ObservableValue<? extends Boolean> ov) {
        JfxUtils.bindDisplayed(ov, node);
    }

    public static void setDisplayed(boolean displayed, Node ... nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes");
        }
        for (Node node : nodes) {
            node.setVisible(displayed);
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
        }
    }

    public static void bindDisplayed(ObservableValue<? extends Boolean> ov, Node ... nodes) {
        Validate.notNull(ov);
        for (Node node : nodes) {
            Validate.notNull((Object)node);
            node.visibleProperty().bind(ov);
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
        }
    }

    public static void bindDisabled(ObservableValue<? extends Boolean> ov, Node ... nodes) {
        Validate.notNull(ov);
        Validate.notNull((Object)nodes);
        Validate.notEmpty((Object[])nodes);
        for (Node node : nodes) {
            node.disableProperty().bind(ov);
        }
    }

    public static void bindDisabled(ObservableValue<? extends Boolean> ov, List<Node> nodes) {
        Validate.notNull(ov);
        Validate.notNull(nodes);
        Validate.notEmpty(nodes);
        for (Node node : nodes) {
            node.disableProperty().bind(ov);
        }
    }

    public static void bindStyleClass(final Node node, ObservableValue<? extends Boolean> ov, final String trueStyle, final String falseStyle) {
        Validate.notNull((Object)node);
        Validate.notNull(ov);
        ov.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                log.debug("bindStyleClass: node={} newValue={}", (Object)node, (Object)newValue);
                if (newValue.booleanValue()) {
                    if (falseStyle != null) {
                        node.getStyleClass().remove((Object)falseStyle);
                    }
                    if (trueStyle != null && !node.getStyleClass().contains((Object)trueStyle)) {
                        node.getStyleClass().add((Object)trueStyle);
                    }
                } else {
                    if (trueStyle != null) {
                        node.getStyleClass().remove((Object)trueStyle);
                    }
                    if (falseStyle != null && !node.getStyleClass().contains((Object)falseStyle)) {
                        node.getStyleClass().add((Object)falseStyle);
                    }
                }
            }
        });
    }

    public static void bindStyleClass(final Tab tab, ObservableValue<? extends Boolean> ov, final String trueStyle, final String falseStyle) {
        Validate.notNull((Object)tab);
        Validate.notNull(ov);
        ov.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                log.debug("bindStyleClass: node={} newValue={}", (Object)tab, (Object)newValue);
                if (newValue.booleanValue()) {
                    if (falseStyle != null) {
                        tab.getStyleClass().remove((Object)falseStyle);
                    }
                    if (trueStyle != null && !tab.getStyleClass().contains((Object)trueStyle)) {
                        tab.getStyleClass().add((Object)trueStyle);
                    }
                } else {
                    if (trueStyle != null) {
                        tab.getStyleClass().remove((Object)trueStyle);
                    }
                    if (falseStyle != null && !tab.getStyleClass().contains((Object)falseStyle)) {
                        tab.getStyleClass().add((Object)falseStyle);
                    }
                }
            }
        });
    }

    public static void bindStylesheet(final Parent parent, ObservableValue<? extends Boolean> ov, String stylesheet) {
        Validate.notNull((Object)parent);
        Validate.notNull(ov);
        Validate.notNull((Object)stylesheet);
        final String stylesheetResource = JfxUtils.getReference(stylesheet);
        ov.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    if (!parent.getStylesheets().contains((Object)stylesheetResource)) {
                        parent.getStylesheets().add((Object)stylesheetResource);
                    }
                } else {
                    parent.getStylesheets().remove((Object)stylesheetResource);
                }
            }
        });
    }

    public static void focusNicely(final Node node, boolean runLater) {
        if (node == null) {
            return;
        }
        if (runLater) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JfxUtils.focusNicelyImpl(node);
                }
            });
        } else {
            JfxUtils.focusNicelyImpl(node);
        }
    }

    public static void focus(final Node node) {
        Validate.notNull((Object)node);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                node.requestFocus();
            }
        });
    }

    public static void focusAndPositionToEnd(final TextField textField) {
        Validate.notNull((Object)textField);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                textField.requestFocus();
                String text = textField.getText();
                textField.positionCaret(text == null ? 0 : text.length());
            }
        });
    }

    public static void addStyleClass(String styleClass, Node ... nodes) {
        Validate.notNull((Object)styleClass);
        for (Node node : nodes) {
            node.getStyleClass().add((Object)styleClass);
        }
    }

    public static void addStyleSheets(Parent parent, String ... stylesheets) {
        Validate.notNull((Object)parent);
        Validate.notNull((Object)stylesheets);
        for (String stylesheet : stylesheets) {
            URL url = JfxUtils.class.getResource(stylesheet);
            String ret = url.toExternalForm();
            log.debug("resourcePath={} url={} externalForm={}", new Object[]{stylesheets, url, ret});
            if (parent.getStylesheets().contains((Object)stylesheet)) continue;
            try {
                parent.getStylesheets().add((Object)ret);
            }
            catch (Exception e) {
                log.warn("Could not add styleSheet: {} at url={}", (Object)stylesheets, (Object)url);
            }
        }
    }

    public static String getReference(String resource) {
        URL url = JfxUtils.class.getResource(resource);
        return url.toExternalForm();
    }

    public static Stage getStage(Node node) {
        Validate.notNull((Object)node, (String)"node is required", (Object[])new Object[0]);
        Window window = node.getScene().getWindow();
        Stage stage = window instanceof Stage ? (Stage)window : null;
        return stage;
    }

    public static List<Node> getAllNodes(Parent parent) {
        Validate.notNull((Object)parent);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : parent.getChildrenUnmodifiable()) {
            nodes.add(node);
            if (!(node instanceof Parent)) continue;
            nodes.addAll(JfxUtils.getAllNodes((Parent)node));
        }
        return nodes;
    }

    public static void bindManagedToVisible(Node ... nodes) {
        for (Node node : nodes) {
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
        }
    }

    public static void bindVisible(@NonNull ObservableValue<? extends Boolean> ov, Node ... nodes) {
        if (ov == null) {
            throw new NullPointerException("ov");
        }
        if (nodes == null) {
            throw new NullPointerException("nodes");
        }
        for (Node node : nodes) {
            node.visibleProperty().bind(ov);
        }
    }

    private static void focusNicelyImpl(Node node) {
        node.requestFocus();
        if (node instanceof TextField) {
            TextField textField;
            String text = (textField = (TextField)node).getText();
            textField.positionCaret(text == null ? 0 : text.length());
        }
    }

    private JfxUtils() {
    }

    private static class ThrowableWrapper {
        Throwable t;

        private ThrowableWrapper() {
        }
    }
}

