/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.layer;

import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import org.lodgon.openmapfx.core.LayeredMap;
import org.lodgon.openmapfx.core.MapLayer;

public class RectangleLayer
extends Region
implements MapLayer,
InvalidationListener {
    private double lat;
    private double lon;
    private double lat2;
    private double lon2;
    private final Rectangle rectangle = new Rectangle();
    private final Label label = new Label();
    private LayeredMap layeredMap;
    private SimpleBooleanProperty selected = new SimpleBooleanProperty();
    private StringProperty overlayColor = new SimpleStringProperty();
    private Callback<String, Void> onOverlaySelect;
    private Callback<String, Void> onOverlayDeselect;
    private boolean flag = false;

    public RectangleLayer(String text) {
        this.getStylesheets().add((Object)("/org/lodgon/openmapfx/layer/" + this.getClass().getSimpleName() + ".css"));
        this.getStyleClass().add((Object)"rectangle-layer");
        this.rectangle.getStyleClass().add((Object)"rectangle-overlay");
        this.getChildren().add((Object)this.rectangle);
        this.label.setText(text);
        this.label.setStyle("-fx-fill:#000000;-fx-text-fill:#000000;");
        this.getChildren().add((Object)this.label);
        this.label.translateXProperty().bind((ObservableValue)this.rectangle.widthProperty().subtract((ObservableNumberValue)this.label.widthProperty()).divide(2));
        this.label.translateYProperty().bind((ObservableValue)this.rectangle.heightProperty().subtract((ObservableNumberValue)this.label.heightProperty()).divide(2));
        this.label.visibleProperty().bind((ObservableValue)this.label.widthProperty().lessThan((ObservableNumberValue)this.rectangle.widthProperty()).and((ObservableBooleanValue)this.label.heightProperty().lessThan((ObservableNumberValue)this.rectangle.heightProperty())));
        this.rectangle.setStyle("-fx-fill:" + this.getOverlayColor() + ";");
        this.configureEvents();
    }

    private void configureEvents() {
        this.setOnMouseClicked(e -> this.selected.set(!this.selected.get()));
        this.overlayColor.addListener(e -> this.rectangle.setStyle("-fx-fill:" + this.getOverlayColor() + ";"));
        this.selected.addListener((o, v, sel) -> {
            if (!this.flag) {
                if (sel.booleanValue()) {
                    this.selectOverlay();
                    if (this.onOverlaySelect != null) {
                        this.onOverlaySelect.call((Object)this.label.getText());
                    }
                } else {
                    this.deselectOverlay();
                    if (this.onOverlayDeselect != null) {
                        this.onOverlayDeselect.call((Object)this.label.getText());
                    }
                }
            }
        });
    }

    @Override
    public Node getView() {
        return this;
    }

    public void setFill(Color color) {
        this.rectangle.setFill((Paint)color);
    }

    public void updatePosition(double lat, double lon, double lat2, double lon2) {
        this.lat = lat;
        this.lon = lon;
        this.lat2 = lat2;
        this.lon2 = lon2;
        this.refreshLayer();
    }

    protected void refreshLayer() {
        Point2D cartPoint = this.layeredMap.getMapPoint(this.lat, this.lon);
        Point2D cartPoint2 = this.layeredMap.getMapPoint(this.lat2, this.lon2);
        if (cartPoint == null || cartPoint2 == null) {
            System.out.println("[JVDBG] Null cartpoint, probably no scene, dont show.");
            return;
        }
        this.setVisible(true);
        this.setTranslateX(cartPoint.getX());
        this.setTranslateY(cartPoint.getY());
        double width = cartPoint2.getX() - cartPoint.getX();
        double height = cartPoint2.getY() - cartPoint.getY();
        this.rectangle.setHeight(height);
        this.rectangle.setWidth(width);
    }

    @Override
    public void gotLayeredMap(LayeredMap map) {
        this.layeredMap = map;
        this.layeredMap.zoomProperty().addListener((InvalidationListener)this);
        this.layeredMap.centerLatitudeProperty().addListener((InvalidationListener)this);
        this.layeredMap.centerLongitudeProperty().addListener((InvalidationListener)this);
        this.layeredMap.xShiftProperty().addListener((InvalidationListener)this);
        this.layeredMap.yShiftProperty().addListener((InvalidationListener)this);
        this.refreshLayer();
    }

    public void invalidated(Observable observable) {
        this.refreshLayer();
    }

    public void selectOverlay() {
        this.getStyleClass().add((Object)"rectangle-layer-select");
    }

    public void deselectOverlay() {
        this.getStyleClass().removeAll((Object[])new String[]{"rectangle-layer-select"});
    }

    public String getOverlayColor() {
        return (String)Optional.ofNullable(this.overlayColor.get()).orElse("#F95F5D");
    }

    public void setOverlayColor(String overlayColor) {
        this.flag = true;
        this.selected.set(overlayColor != null);
        this.overlayColor.set((Object)overlayColor);
        this.flag = false;
    }

    public Callback<String, Void> getOnOverlaySelect() {
        return this.onOverlaySelect;
    }

    public void setOnOverlaySelect(Callback<String, Void> onOverlaySelect) {
        this.onOverlaySelect = onOverlaySelect;
    }

    public Callback<String, Void> getOnOverlayDeselect() {
        return this.onOverlayDeselect;
    }

    public void setOnOverlayDeselect(Callback<String, Void> onOverlayDeselect) {
        this.onOverlayDeselect = onOverlayDeselect;
    }
}

