/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.io.InputStream;
import java.net.URL;
import org.lodgon.openmapfx.core.MapTileType;

public class SimpleTileType
implements MapTileType {
    private final String typeName;
    private final String baseURL;
    private final String attributionNotice;

    public SimpleTileType(String typeName, String baseURL) {
        this.typeName = typeName;
        this.baseURL = baseURL;
        this.attributionNotice = "";
    }

    public SimpleTileType(String typeName, String baseURL, String attributionNotice) {
        this.typeName = typeName;
        this.baseURL = baseURL;
        this.attributionNotice = attributionNotice;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getBaseURL(int zoom, long i, long j) {
        String ret = this.baseURL + zoom + "/" + i + "/" + j + ".png";
        return ret;
    }

    @Override
    public InputStream getInputStream(int zoom, long i, long j) throws Exception {
        return new URL(this.getBaseURL(zoom, i, j)).openStream();
    }

    @Override
    public String getAttributionNotice() {
        return this.attributionNotice;
    }

    public String toString() {
        return this.getTypeName();
    }
}

