/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.lodgon.openmapfx.core.BaseMap;
import org.lodgon.openmapfx.core.MapTile;
import org.lodgon.openmapfx.core.MapTileType;

public class MapArea
extends Group
implements BaseMap {
    public static final double TIPPING = 0.2;
    public static final int MAX_ZOOM = 20;
    private final Map<String, SoftReference<MapTile>>[] tiles = new HashMap[20];
    private int nearestZoom;
    private final DoubleProperty zoomProperty = new SimpleDoubleProperty();
    private double userRequestedLat;
    private double userRequestedLon;
    private boolean debug = true;
    private final Rectangle area;
    private DoubleProperty centerLon = new SimpleDoubleProperty();
    private DoubleProperty centerLat = new SimpleDoubleProperty();
    private final ObservableList<MapTileType> tileTypes;
    private Region viewPort;
    private Timeline repaintTimeLine = new Timeline();

    public MapArea(ObservableList<MapTileType> tileTypes) {
        this.tileTypes = tileTypes;
        for (int i = 0; i < this.tiles.length; ++i) {
            this.tiles[i] = new HashMap<String, SoftReference<MapTile>>();
        }
        this.area = new Rectangle(-10.0, -10.0, 810.0, 610.0);
        this.area.setVisible(false);
        this.repaintTimeLine.getKeyFrames().add((Object)new KeyFrame(new Duration(200.0), this::repaint, new KeyValue[0]));
        this.zoomProperty.addListener((ov, t, t1) -> {
            this.nearestZoom = Math.min((int)Math.floor(t1.doubleValue() + 0.2), 19);
        });
        this.tileTypes.addListener((ListChangeListener)new ListChangeListener<MapTileType>(){

            public void onChanged(ListChangeListener.Change<? extends MapTileType> c) {
                while (c.next()) {
                    if (c.wasRemoved()) {
                        MapArea.this.clearTiles(c.getRemoved());
                        continue;
                    }
                    if (c.wasAdded()) {
                        MapArea.this.loadTiles(c.getAddedSubList());
                        continue;
                    }
                    if (c.wasReplaced()) {
                        System.out.println("!!!Replaced not implemented");
                        continue;
                    }
                    if (!c.wasPermutated()) continue;
                    System.out.println("!!!Permutated not implemented");
                }
            }
        });
    }

    private void triggerRepaint() {
        this.repaintTimeLine.stop();
        this.repaintTimeLine.playFromStart();
    }

    private void repaint(ActionEvent ae) {
        this.clearTiles(null);
        this.setCenter(this.userRequestedLat, this.userRequestedLon);
    }

    public ObservableList<MapTileType> tileTypeProperty() {
        return this.tileTypes;
    }

    @Override
    public void setCenter(double lat, double lon) {
        this.userRequestedLat = lat;
        this.userRequestedLon = lon;
        if (this.getScene() == null || this.getViewPort() == null || this.tileTypes.isEmpty()) {
            if (this.debug) {
                System.out.println("Ignore setting center . scene = " + this.getScene() + " viewPort=" + this.viewPort + " tileType=" + this.tileTypes);
            }
            return;
        }
        double activeZoom = this.zoomProperty.get();
        double n = Math.pow(2.0, activeZoom);
        double lat_rad = Math.PI * lat / 180.0;
        double id = n / 360.0 * (180.0 + lon);
        double jd = n * (1.0 - Math.log(Math.tan(lat_rad) + 1.0 / Math.cos(lat_rad)) / Math.PI) / 2.0;
        double mex = id * 256.0;
        double mey = jd * 256.0;
        double viewPortWidth = this.viewPort.getWidth();
        double viewPortHeight = this.viewPort.getHeight();
        System.out.println("viewPortWidth = " + viewPortWidth);
        System.out.println("viewPortHeight = " + viewPortHeight);
        double ttx = mex - this.viewPort.getWidth() / 2.0;
        double tty = mey - this.viewPort.getHeight() / 2.0;
        this.setTranslateX(-1.0 * ttx);
        this.setTranslateY(-1.0 * tty);
        if (this.debug) {
            System.out.println("setCenter, tx = " + this.getTranslateX() + ", width = " + this.viewPort.getWidth() / 2.0 + ", mex = " + mex);
        }
        this.loadTiles();
    }

    @Override
    public void moveX(double dx) {
        this.setTranslateX(this.getTranslateX() - dx);
        this.loadTiles();
        this.updateUserRequestedLatLong();
    }

    @Override
    public void moveY(double dy) {
        double zoom = this.zoomProperty.get();
        double maxty = 256.0 * Math.pow(2.0, zoom) - this.getViewPort().getHeight();
        if (this.debug) {
            System.out.println("ty = " + this.getTranslateY() + " and dy = " + dy);
        }
        if (this.getTranslateY() <= 0.0) {
            if (this.getTranslateY() + maxty >= 0.0) {
                this.setTranslateY(Math.min(0.0, this.getTranslateY() - dy));
            } else {
                this.setTranslateY(-maxty + 1.0);
            }
        } else {
            this.setTranslateY(0.0);
        }
        this.loadTiles();
        this.updateUserRequestedLatLong();
    }

    public void loadTiles() {
        this.loadTiles((List<MapTileType>)this.tileTypes);
    }

    @Override
    public void setZoom(double z) {
        if (this.debug) {
            System.out.println("seting zoom to " + z);
        }
        this.zoomProperty.set(z);
        this.loadTiles();
    }

    @Override
    public void zoom(double delta, double pivotX, double pivotY) {
        double dz = delta > 0.0 ? 0.1 : -0.1;
        double zp = this.zoomProperty.get();
        if (this.debug) {
            System.out.println("Zoom called, zp = " + zp + ", delta = " + delta + ", px = " + pivotX + ", py = " + pivotY);
        }
        double txold = this.getTranslateX();
        double t1x = pivotX - this.getTranslateX();
        double t2x = 1.0 - Math.pow(2.0, dz);
        double totX = t1x * t2x;
        double tyold = this.getTranslateY();
        double t1y = pivotY - tyold;
        double t2y = 1.0 - Math.pow(2.0, dz);
        double totY = t1y * t2y;
        if (this.debug) {
            System.out.println("zp = " + zp + ", txold = " + txold + ", totx = " + totX + ", tyold = " + tyold + ", toty = " + totY);
        }
        if (delta > 0.0) {
            if (zp < 20.0) {
                this.setTranslateX(txold + totX);
                this.setTranslateY(tyold + totY);
                this.zoomProperty.set(zp + 0.1);
                this.loadTiles();
            }
        } else if (zp > 1.0) {
            double nz = zp - 0.1;
            if (Math.pow(2.0, nz) * 256.0 > this.getViewPort().getHeight()) {
                this.setTranslateX(txold + totX);
                this.setTranslateY(tyold + totY);
                this.zoomProperty.set(zp - 0.1);
                this.loadTiles();
            } else {
                System.out.println("sorry, would be too small");
            }
        }
        if (this.debug) {
            System.out.println("after, zp = " + this.zoomProperty.get());
        }
        this.calculateCenterCoords();
        this.updateUserRequestedLatLong();
    }

    private void updateUserRequestedLatLong() {
        this.userRequestedLat = this.centerLat.get();
        this.userRequestedLon = this.centerLon.get();
    }

    @Override
    public DoubleProperty zoomProperty() {
        return this.zoomProperty;
    }

    @Override
    public Point2D getMapPoint(double lat, double lon) {
        return this.getMapPoint(this.zoomProperty.get(), lat, lon);
    }

    private Point2D getMapPoint(double zoom, double lat, double lon) {
        if (this.getScene() == null) {
            return null;
        }
        double n = Math.pow(2.0, zoom);
        double lat_rad = Math.PI * lat / 180.0;
        double id = n / 360.0 * (180.0 + lon);
        double jd = n * (1.0 - Math.log(Math.tan(lat_rad) + 1.0 / Math.cos(lat_rad)) / Math.PI) / 2.0;
        double mex = id * 256.0;
        double mey = jd * 256.0;
        double ttx = mex - this.getViewPort().getWidth() / 2.0;
        double tty = mey - this.getViewPort().getHeight() / 2.0;
        double x = this.getTranslateX() + mex;
        double y = this.getTranslateY() + mey;
        Point2D answer = new Point2D(x, y);
        return answer;
    }

    private void calculateCenterCoords() {
        double x = this.getViewPort().getWidth() / 2.0 - this.getTranslateX();
        double y = this.getViewPort().getHeight() / 2.0 - this.getTranslateY();
        double zoom = this.zoomProperty.get();
        double latrad = Math.PI - Math.PI * 2 * y / (Math.pow(2.0, zoom) * 256.0);
        double mlat = Math.toDegrees(Math.atan(Math.sinh(latrad)));
        double mlon = x / (256.0 * Math.pow(2.0, zoom)) * 360.0 - 180.0;
        if (this.debug) {
            System.out.println("previous center coords");
            this.debugCenter();
        }
        this.centerLon.set(mlon);
        this.centerLat.set(mlat);
        System.out.println("new center coords");
        this.debugCenter();
    }

    private void debugCenter() {
        System.out.println("center lat = " + this.centerLat.get() + " centerLon=" + this.centerLon.get());
    }

    @Override
    public DoubleProperty centerLon() {
        return this.centerLon;
    }

    @Override
    public DoubleProperty centerLat() {
        return this.centerLat;
    }

    private void loadTiles(List<MapTileType> type) {
        if (this.getScene() == null || this.getViewPort() == null || type == null) {
            return;
        }
        double activeZoom = this.zoomProperty.get();
        double deltaZ = (double)this.nearestZoom - activeZoom;
        long i_max = 1 << this.nearestZoom;
        long j_max = 1 << this.nearestZoom;
        double tx = this.getTranslateX();
        double ty = this.getTranslateY();
        double width = this.getViewPort().getWidth();
        double height = this.getViewPort().getHeight();
        if (width == 0.0 || height == 0.0) {
            System.out.println("Not loading tiles as width = " + width + " and height= " + height);
            return;
        }
        long imin = Math.max(0L, (long)(-tx * Math.pow(2.0, deltaZ) / 256.0) - 1L);
        long jmin = Math.max(0L, (long)(-ty * Math.pow(2.0, deltaZ) / 256.0));
        long imax = Math.min(i_max, imin + (long)(width * Math.pow(2.0, deltaZ) / 256.0) + 3L);
        long jmax = Math.min(j_max, jmin + (long)(height * Math.pow(2.0, deltaZ) / 256.0) + 3L);
        if (this.debug) {
            System.out.println("zoom = " + this.nearestZoom + ", active = " + activeZoom + ", loadtiles, check i-range: " + imin + ", " + imax + " and j-range: " + jmin + ", " + jmax);
        }
        for (long i = imin; i < imax; ++i) {
            for (long j = jmin; j < jmax; ++j) {
                for (MapTileType mtt : type) {
                    MapTile tile;
                    String key = mtt.getTypeName() + "_" + i * i_max + j;
                    SoftReference<MapTile> ref = this.tiles[this.nearestZoom].get(key);
                    System.out.println("Cache entry for zoom " + this.nearestZoom + ",i=" + i + ",j=" + j + " ref=" + ref);
                    if (ref == null || ref.get() == null) {
                        if (ref != null) {
                            System.out.println("RECLAIMED: z=" + this.nearestZoom + ",i=" + i + ",j=" + j);
                        }
                        tile = new MapTile(this, mtt, this.nearestZoom, i, j);
                        this.tiles[this.nearestZoom].put(key, new SoftReference<MapTile>(tile));
                        MapTile covering = tile.getCoveringTile();
                        if (covering != null && !this.getChildren().contains((Object)covering)) {
                            this.getChildren().add((Object)covering);
                        }
                        this.getChildren().add((Object)tile);
                        continue;
                    }
                    System.out.println("Tile was cached " + key);
                    tile = ref.get();
                    tile.loadNow();
                    if (this.getChildren().contains((Object)tile)) continue;
                    this.getChildren().add((Object)tile);
                }
            }
        }
        this.calculateCenterCoords();
        this.cleanupTiles();
        System.out.println("children " + this.getChildren().size());
    }

    protected MapTile findCovering(int zoom, long i, long j) {
        while (zoom > 0) {
            MapTile candidate;
            if ((candidate = this.findTile(--zoom, i /= 2L, j /= 2L)) == null || candidate.loading()) continue;
            return candidate;
        }
        return null;
    }

    private MapTile findTile(int zoom, long i, long j) {
        Long key = i * (long)(1 << zoom) + j;
        SoftReference<MapTile> exists = this.tiles[zoom].get(key);
        return exists == null ? null : exists.get();
    }

    private void cleanupTiles() {
        if (this.debug) {
            System.out.println("START CLEANUP");
        }
        double zp = this.zoomProperty.get();
        LinkedList<MapTile> toRemove = new LinkedList<MapTile>();
        Parent parent = this.getParent();
        ObservableList children = this.getChildren();
        for (Node child : children) {
            if (!(child instanceof MapTile)) continue;
            MapTile tile = (MapTile)child;
            boolean intersects = tile.getBoundsInParent().intersects(this.area.getBoundsInParent());
            if (this.debug) {
                // empty if block
            }
            if (!intersects) {
                boolean loading;
                if (this.debug) {
                    // empty if block
                }
                if (loading = tile.loading()) continue;
                toRemove.add(tile);
                continue;
            }
            if ((double)tile.getZoomLevel() > Math.ceil(zp)) {
                if (this.debug) {
                    // empty if block
                }
                toRemove.add(tile);
                continue;
            }
            if (!((double)tile.getZoomLevel() < Math.floor(zp + 0.2)) || tile.isCovering() || Math.ceil(zp) >= 20.0) continue;
            if (this.debug) {
                // empty if block
            }
            toRemove.add(tile);
        }
        this.getChildren().removeAll(toRemove);
        if (this.debug) {
            System.out.println("DONE CLEANUP");
        }
    }

    private void reloadTiles() {
        System.out.println("reloadTiles begin");
    }

    private void clearTiles(List<MapTileType> mtt) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        ObservableList children = this.getChildren();
        for (Node child : children) {
            if (!(child instanceof MapTile)) continue;
            MapTile mt = (MapTile)child;
            if (mtt != null && !mtt.contains(mt.getTileType())) continue;
            toRemove.add(child);
        }
        this.getChildren().removeAll(toRemove);
    }

    @Override
    public Node getView() {
        return this;
    }

    @Override
    public void install(Region vp) {
        this.viewPort = vp;
        this.area.translateXProperty().bind((ObservableValue)this.translateXProperty().multiply(-1));
        this.area.translateYProperty().bind((ObservableValue)this.translateYProperty().multiply(-1));
        if (vp != null) {
            vp.widthProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    MapArea.this.triggerRepaint();
                }
            });
            vp.heightProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    System.out.println("viewPort height changed, reloading tiles");
                    MapArea.this.triggerRepaint();
                }
            });
            this.area.widthProperty().bind((ObservableValue)vp.widthProperty().add(20));
            this.area.heightProperty().bind((ObservableValue)vp.heightProperty().add(20));
            this.triggerRepaint();
        }
    }

    @Override
    public void uninstall() {
        this.area.translateXProperty().unbind();
        this.area.translateYProperty().unbind();
        this.area.widthProperty().unbind();
        this.area.heightProperty().unbind();
        this.clearTiles(null);
    }

    @Override
    public Region getViewPort() {
        return this.viewPort;
    }
}

