/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.lodgon.openmapfx.core.BaseMap;
import org.lodgon.openmapfx.core.BaseMapProvider;
import org.lodgon.openmapfx.core.MapLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayeredMap
extends Region {
    private static final Logger log = LoggerFactory.getLogger(LayeredMap.class);
    private BaseMap mapArea;
    private double x0;
    private double y0;
    private final ObservableList<MapLayer> layers = FXCollections.observableArrayList();
    private ObjectProperty<BaseMapProvider> provider = new SimpleObjectProperty();

    public LayeredMap(BaseMapProvider provider) {
        this.provider.set((Object)provider);
        this.mapArea = provider.getBaseMap();
        this.getChildren().add((Object)this.mapArea.getView());
        this.layers.addListener((ListChangeListener)new ListChangeListener<MapLayer>(){

            public void onChanged(ListChangeListener.Change<? extends MapLayer> c) {
                while (c.next()) {
                    for (MapLayer candidate : c.getAddedSubList()) {
                        Node view = candidate.getView();
                        LayeredMap.this.getChildren().add((Object)view);
                        candidate.gotLayeredMap(LayeredMap.this);
                    }
                    for (MapLayer target : c.getRemoved()) {
                        LayeredMap.this.getChildren().remove((Object)target.getView());
                    }
                }
            }
        });
        this.setOnMousePressed(t -> {
            this.x0 = t.getSceneX();
            this.y0 = t.getSceneY();
        });
        this.setOnMouseDragged(t -> {
            this.mapArea.moveX(this.x0 - t.getSceneX());
            this.mapArea.moveY(this.y0 - t.getSceneY());
            this.x0 = t.getSceneX();
            this.y0 = t.getSceneY();
        });
        this.setOnZoom(t -> this.mapArea.zoom(t.getZoomFactor() > 1.0 ? 0.1 : -0.1, (this.x0 + t.getX()) / 2.0, (this.y0 + t.getY()) / 2.0));
        this.setOnScroll(t -> this.mapArea.zoom(t.getDeltaY(), t.getX(), t.getY()));
    }

    public void install(Region viewPort) {
        this.mapArea.install(viewPort);
    }

    public void setBaseMapProvider(BaseMapProvider provider) {
        this.provider.set((Object)provider);
        this.resetBaseMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBaseMap() {
        double zm = this.zoomProperty().get();
        double lat = this.centerLatitudeProperty().get();
        double lng = this.centerLongitudeProperty().get();
        this.mapArea.uninstall();
        this.getChildren().remove((Object)this.mapArea.getView());
        this.mapArea = ((BaseMapProvider)this.provider.get()).getBaseMap();
        this.getChildren().add(0, (Object)this.mapArea.getView());
        this.mapArea.install(this.mapArea.getViewPort());
        this.mapArea.setZoom(zm);
        this.mapArea.setCenter(lat, lng);
        ObservableList<MapLayer> observableList = this.layers;
        synchronized (observableList) {
            for (MapLayer ml : this.layers) {
                ml.gotLayeredMap(this);
            }
        }
    }

    public void setZoom(double z) {
        this.mapArea.setZoom(z);
    }

    public void setCenter(double lat, double lon) {
        this.mapArea.setCenter(lat, lon);
    }

    public BaseMap getMapArea() {
        return this.mapArea;
    }

    public ObservableList<MapLayer> getLayers() {
        return this.layers;
    }

    public Point2D getMapPoint(double lat, double lon) {
        return this.mapArea.getMapPoint(lat, lon);
    }

    public DoubleProperty zoomProperty() {
        return this.mapArea.zoomProperty();
    }

    public DoubleProperty xShiftProperty() {
        return this.mapArea.getView().translateXProperty();
    }

    public DoubleProperty yShiftProperty() {
        return this.mapArea.getView().translateYProperty();
    }

    public DoubleProperty centerLongitudeProperty() {
        return this.mapArea.centerLon();
    }

    public DoubleProperty centerLatitudeProperty() {
        return this.mapArea.centerLat();
    }
}

