/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.lodgon.openmapfx.core.BaseMap;
import org.lodgon.openmapfx.core.BaseMapProvider;
import org.lodgon.openmapfx.core.MapArea;
import org.lodgon.openmapfx.core.MapTileType;
import org.lodgon.openmapfx.core.TileProvider;
import org.lodgon.openmapfx.providers.FileProvider;
import org.lodgon.openmapfx.providers.MapQuestTileProvider;
import org.lodgon.openmapfx.providers.OSMTileProvider;
import org.lodgon.openmapfx.providers.StamenTileProvider;

public class DefaultBaseMapProvider
implements BaseMapProvider {
    private static final String mapName = "OpenMapFX Tiled Map";
    private MapArea baseMap;
    private static final List<TileProvider> tileProviders = new LinkedList<TileProvider>();
    private final ObjectProperty<TileProvider> selectedProvider = new SimpleObjectProperty();
    private final ObjectProperty<MapTileType> tilesOfSelectedProvider = new SimpleObjectProperty();
    private final ObservableList<MapTileType> selectedTileTypes = FXCollections.observableArrayList();

    public DefaultBaseMapProvider() {
        this.selectedProvider.set((Object)tileProviders.get(0));
        this.tilesOfSelectedProvider.set((Object)((TileProvider)this.selectedProvider.get()).getDefaultType());
    }

    @Override
    public String getMapName() {
        return mapName;
    }

    @Override
    public BaseMap getBaseMap() {
        if (this.baseMap == null) {
            this.baseMap = new MapArea(this.selectedTileTypes);
        }
        return this.baseMap;
    }

    public List<TileProvider> getTileProviders() {
        return tileProviders;
    }

    @Override
    public ObservableList<MapTileType> tileTypesProperty() {
        return this.selectedTileTypes;
    }

    public String toString() {
        return this.getMapName();
    }

    static {
        tileProviders.add(new OSMTileProvider());
        tileProviders.add(new MapQuestTileProvider());
        tileProviders.add(new StamenTileProvider());
        if (System.getProperty("fileProvider") != null) {
            FileProvider fp = new FileProvider("OSM local", System.getProperty("fileProvider"));
            tileProviders.add(fp);
        }
    }
}

