/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.thread;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxThreadProxy<T>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(FxThreadProxy.class);
    private T delegate;

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke(this.delegate, args);
        }
        if (Platform.isFxApplicationThread()) {
            return method.invoke(this.delegate, args);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    log.trace("Invoking {} in listener {} with args {}", new Object[]{method.getName(), FxThreadProxy.this.delegate, args});
                    method.invoke(FxThreadProxy.this.delegate, args);
                }
                catch (Throwable e) {
                    log.error("Exception Invoking " + method.getName() + " in delegate " + FxThreadProxy.this.delegate + " with args " + args, e);
                }
            }
        });
        return null;
    }

    public static <T> T newInstance(Class<T> clazz, T delegate) {
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new FxThreadProxy<T>(delegate));
        return (T)proxy;
    }

    public FxThreadProxy() {
    }

    @ConstructorProperties(value={"delegate"})
    public FxThreadProxy(T delegate) {
        this.delegate = delegate;
    }

    public T getDelegate() {
        return this.delegate;
    }
}

