/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control.util;

import javafx.scene.control.TextField;
import jfxtras.labs.internal.scene.control.skin.BigDecimalFieldSkin;
import jfxtras.labs.scene.control.BigDecimalField;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VKUtils {
    private static final Logger log = LoggerFactory.getLogger(VKUtils.class);
    public static final String VK_TYPE_PROP_KEY = "vkType";
    public static final String VK_TYPE_NUMERIC_NAME = "numeric";

    public static void configureNumericKeyboard(TextField ... fields) {
        Validate.noNullElements((Object[])fields);
        for (TextField tf : fields) {
            tf.getProperties().put((Object)VK_TYPE_PROP_KEY, (Object)VK_TYPE_NUMERIC_NAME);
        }
    }

    public static void configureNumericKeyboard(BigDecimalField ... fields) {
        for (BigDecimalField bdf : fields) {
            bdf.skinProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    BigDecimalFieldSkin skin = (BigDecimalFieldSkin)bdf.getSkin();
                    TextField tf = (TextField)FieldUtils.readDeclaredField((Object)skin, (String)"textField", (boolean)true);
                    VKUtils.configureNumericKeyboard(tf);
                }
                catch (Exception e) {
                    log.warn("Couldn't set numeric keyboard on BigDecimalField= " + bdf, (Throwable)e);
                }
            });
        }
    }

    private VKUtils() {
    }
}

