/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control.util;

import com.anahata.jfx.scene.control.DisplayableListCellFactory;
import com.anahata.util.formatting.Displayable;
import java.util.Collection;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class ComboBoxUtils {
    public static <T> void setComboBoxCellFactory(ComboBox<T> comboBox, Callback<ListView<T>, ListCell<T>> cellFactory) {
        Validate.notNull(comboBox);
        Validate.notNull(cellFactory);
        comboBox.setCellFactory(cellFactory);
        comboBox.setButtonCell((ListCell)cellFactory.call(null));
    }

    public static <T extends Displayable> void populateDisplayableCollectionComboBox(@NonNull ComboBox<T> comboBox, @NonNull Collection<T> values, boolean addNull) {
        if (comboBox == null) {
            throw new NullPointerException("comboBox");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        DisplayableListCellFactory.setComboBoxCellFactory(comboBox);
        if (addNull) {
            comboBox.getItems().add(null);
        }
        comboBox.getItems().addAll(values);
    }

    public static <T extends Enum> void populateDisplayableEnumComboBox(ComboBox<T> comboBox, Class<T> enumClass, boolean addNull) {
        Validate.notNull(comboBox);
        Validate.notNull(enumClass);
        DisplayableListCellFactory.setComboBoxCellFactory(comboBox);
        if (addNull) {
            comboBox.getItems().add(null);
        }
        comboBox.getItems().addAll((Object[])enumClass.getEnumConstants());
    }

    public static void showListOnFocus(ComboBox ... nodes) {
        for (ComboBox node : nodes) {
            node.focusedProperty().addListener((obs, old, focused) -> {
                if (focused.booleanValue()) {
                    node.show();
                }
            });
        }
    }

    private ComboBoxUtils() {
    }
}

