/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.scene.control.AbstractEntityTreeItem;
import javafx.scene.control.TreeView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityTreeView {
    private static final Logger log = LoggerFactory.getLogger(EntityTreeView.class);

    public static void selectInTree(TreeView tree, Object entity) {
        AbstractEntityTreeItem wrapper = ((AbstractEntityTreeItem)tree.getRoot()).expandPathToEntity(entity);
        if (wrapper != null) {
            log.debug("selectInTree found entity {}", entity);
            tree.getSelectionModel().select((Object)wrapper);
            tree.requestFocus();
        } else {
            log.debug("selectInTree did not find entity {}", entity);
        }
    }

    public static Object getTreeSelectedEntity(TreeView tree) {
        AbstractEntityTreeItem selectedItem;
        if (tree != null && (selectedItem = (AbstractEntityTreeItem)((Object)tree.getSelectionModel().getSelectedItem())) != null) {
            return selectedItem.getEntity();
        }
        return null;
    }

    private EntityTreeView() {
    }
}

