/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.bind.nodemodel.NodeModel;
import com.anahata.util.formatting.Displayable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.Validate;

public class CheckboxList<T>
extends VBox
implements NodeModel<CheckboxList, SetProperty> {
    private final SetProperty<T> value = new SimpleSetProperty(FXCollections.observableSet(new HashSet()));

    public ObservableSet<T> getValue() {
        return (ObservableSet)this.value.get();
    }

    public void setValue(ObservableSet<T> value) {
        this.value.set(value);
    }

    public SetProperty<T> valueProperty() {
        return this.value;
    }

    public CheckboxList() {
        this.setPrefHeight(-1.0);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setSpacing(8.0);
        this.setStyle("-fx-border: solid 2px red;");
        this.value.addListener(new ChangeListener<Set<T>>(){

            public void changed(ObservableValue<? extends Set<T>> ov, Set<T> oldValue, Set<T> newValue) {
                for (Node node : CheckboxList.this.getChildren()) {
                    CheckBox cb = (CheckBox)node;
                    Object currValue = cb.getUserData();
                    cb.setSelected(newValue != null && newValue.contains(currValue));
                }
            }
        });
    }

    public void init(T[] values) {
        this.init(Arrays.asList(values));
    }

    public void setRawValue(Set s) {
        this.value.setValue(FXCollections.observableSet((Set)s));
    }

    public void init(Collection<T> values) {
        Validate.notNull(values);
        this.getChildren().clear();
        this.value.setValue(FXCollections.observableSet((Object[])new Object[0]));
        for (T currValue : values) {
            String description = currValue instanceof Displayable ? ((Displayable)currValue).getDisplayValue() : currValue.toString();
            final CheckBox cb = new CheckBox(description);
            cb.setWrapText(true);
            cb.setUserData(currValue);
            this.getChildren().add((Object)cb);
            cb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                    Object eValue = cb.getUserData();
                    if (newValue.booleanValue()) {
                        ((ObservableSet)CheckboxList.this.value.get()).add(eValue);
                    } else {
                        ((ObservableSet)CheckboxList.this.value.get()).remove(eValue);
                    }
                }
            });
        }
    }

    @Override
    public SetProperty getNodeModelValueProperty(CheckboxList node) {
        return node.valueProperty();
    }
}

