/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.bind.nodemodel.NodeModel;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.util.Callback;

public class CalendarTextField
extends Control
implements NodeModel<CalendarTextField, ObjectProperty> {
    private final BooleanProperty textFieldFocused = new SimpleBooleanProperty(false);
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty((Object)this, "calendar", null);
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty<Locale>(Locale.getDefault()){

        public void set(Locale value) {
            super.set((Object)value);
            if (!CalendarTextField.this.dateFormatManual) {
                CalendarTextField.this.setDateFormat(SimpleDateFormat.getDateInstance(2, value));
            }
        }
    };
    private final ObjectProperty<DateFormat> dateFormatObjectProperty = new SimpleObjectProperty<DateFormat>((Object)this, "dateFormat", SimpleDateFormat.getDateInstance(2, this.getLocale())){

        public void set(DateFormat value) {
            super.set((Object)value);
            CalendarTextField.this.dateFormatManual = true;
            if (value != null) {
                try {
                    Field field = value.getClass().getDeclaredField("locale");
                    field.setAccessible(true);
                    Locale lLocale = (Locale)field.get(value);
                    if (lLocale != null) {
                        CalendarTextField.this.setLocale(lLocale);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    };
    private boolean dateFormatManual = false;
    private final ObjectProperty<String> promptTextObjectProperty = new SimpleObjectProperty((Object)this, "promptText", null);
    ListProperty<DateFormat> dateFormatsProperty = new SimpleListProperty(FXCollections.observableList(new ArrayList()));
    private final ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackObjectProperty = new SimpleObjectProperty((Object)this, "parseErrorCallback", null);

    public CalendarTextField() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)this.getClass().getSimpleName());
    }

    public String getUserAgentStylesheet() {
        return this.getClass().getResource("/com/anahata/jfx/internal/scene/control/" + CalendarTextField.class.getSimpleName() + ".css").toExternalForm();
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        return this.dateFormatObjectProperty;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatObjectProperty.getValue();
    }

    public void setDateFormat(DateFormat value) {
        this.dateFormatObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withDateFormat(DateFormat value) {
        this.setDateFormat(value);
        return this;
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptTextObjectProperty;
    }

    public String getPromptText() {
        return (String)this.promptTextObjectProperty.get();
    }

    public void setPromptText(String value) {
        this.promptTextObjectProperty.set((Object)value);
    }

    public CalendarTextField withPromptText(String value) {
        this.setPromptText(value);
        return this;
    }

    public ListProperty<DateFormat> dateFormatsProperty() {
        return this.dateFormatsProperty;
    }

    public ObservableList<DateFormat> getDateFormats() {
        return this.dateFormatsProperty.getValue();
    }

    public void setDateFormats(ObservableList<DateFormat> value) {
        this.dateFormatsProperty.setValue(value);
    }

    public CalendarTextField withDateFormat(ObservableList<DateFormat> value) {
        this.setDateFormats(value);
        return this;
    }

    public ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackProperty() {
        return this.parseErrorCallbackObjectProperty;
    }

    public Callback<Throwable, Void> getParseErrorCallback() {
        return (Callback)this.parseErrorCallbackObjectProperty.getValue();
    }

    public void setParseErrorCallback(Callback<Throwable, Void> value) {
        this.parseErrorCallbackObjectProperty.setValue(value);
    }

    public CalendarTextField withParseErrorCallback(Callback<Throwable, Void> value) {
        this.setParseErrorCallback(value);
        return this;
    }

    @Override
    public ObjectProperty getNodeModelValueProperty(CalendarTextField node) {
        return node.calendarProperty();
    }

    public BooleanProperty textFieldFocusedProperty() {
        return this.textFieldFocused;
    }
}

