/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.message;

import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.View;
import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.message.JfxMessageContext;
import com.anahata.jfx.validator.DynamicValidationMarker;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;

@Dependent
public class JfxMessages {
    @Inject
    private DynamicValidationMarker marker;
    private final WeakHashMap<View, Void> views = new WeakHashMap();

    public void addMessage(View view, Node node, JfxMessage message) {
        if (message == null) {
            return;
        }
        Validate.notNull((Object)view, (String)"The view is required", (Object[])new Object[0]);
        JfxMessageContext context = new JfxMessageContext(view, node, message);
        view.getGrowl().addMessage(context);
        this.views.put(view, null);
        this.marker.addMessage(context);
    }

    public void clearMessages() {
        for (View v : this.views.keySet()) {
            if (v == null || v.getGrowl() == null) continue;
            v.getGrowl().clearAllMessages();
        }
        this.marker.clearAllMessages();
    }

    public void clearAndAddMessage(View view, Node node, JfxMessage message) {
        this.clearMessages();
        this.addMessage(view, node, message);
    }

    public void clearAndAddInfoMessage(Binder binder, String message) {
        this.clearMessages();
        this.addMessage(binder.getView(null), null, JfxMessage.info(message));
    }

    public void clearIdMessages() {
        this.marker.clearAllMessages();
    }

    public void clearMessage(Node node) {
        Validate.notNull((Object)node);
        this.marker.clearMessages(node);
    }
}

