/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.internal.scene.control.behavior;

import com.anahata.jfx.concurrent.ApplicationTask;
import com.anahata.jfx.internal.scene.control.skin.AutoCompleteTextFieldSkin;
import com.anahata.jfx.scene.control.AutoCompleteTextField;
import com.anahata.util.lang.Nvl;
import com.anahata.yam.model.search.ExpandSearch;
import com.anahata.yam.model.search.FullTextCriteria;
import com.anahata.yam.service.search.PojoSearch;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoCompleteTextFieldBehavior<T>
extends BehaviorBase<AutoCompleteTextField<T>> {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteTextFieldBehavior.class);
    private final ObservableList<T> autoCompleteList = FXCollections.observableArrayList();
    private Comparator<T> listComparator;
    private boolean updatingField = false;
    private AutoCompleteTextFieldSkin<T> skin;
    private StringProperty text = new SimpleStringProperty("");
    private DataProviderTask dataProviderTask = null;
    private Timeline dataProviderTaskLauncher = new Timeline();
    private ListChangeListener<T> dataChangeListener = new ListChangeListener<T>(){

        public void onChanged(ListChangeListener.Change<? extends T> c) {
            log.debug("data changed {}", c);
            while (c.next()) {
                AutoCompleteTextFieldBehavior.this.autoCompleteList.removeAll((Collection)c.getRemoved());
                AutoCompleteTextFieldBehavior.this.extractMatchingItems(c.getAddedSubList(), Nvl.nvl((String)AutoCompleteTextFieldBehavior.this.skin.getTextField().getText()).trim().toLowerCase());
            }
        }
    };
    private InvalidationListener valueInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            Object newValue = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getValue();
            log.debug("valueInvalidationListener {} updating={}", newValue, (Object)AutoCompleteTextFieldBehavior.this.updatingField);
            if (!AutoCompleteTextFieldBehavior.this.updatingField) {
                AutoCompleteTextFieldBehavior.this.updatingField = true;
                if (newValue == null) {
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().setText(null);
                } else if (newValue instanceof String) {
                    if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getMode() == AutoCompleteTextField.Mode.TYPED_ONLY) {
                        throw new IllegalStateException("String '" + newValue + "' can not be used as value when working in checked mode");
                    }
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().setText((String)newValue);
                } else {
                    if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getMode() == AutoCompleteTextField.Mode.STRING_ONLY) {
                        throw new IllegalStateException("Only string values are supported");
                    }
                    String text = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataFormatter().toTextFieldString(newValue);
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().setText(text);
                }
                AutoCompleteTextFieldBehavior.this.updatingField = false;
            }
        }
    };
    private ChangeListener valueChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            log.debug("valueChangeListener {} updating={}", newValue, (Object)AutoCompleteTextFieldBehavior.this.updatingField);
            if (!AutoCompleteTextFieldBehavior.this.updatingField) {
                AutoCompleteTextFieldBehavior.this.updatingField = true;
                if (newValue == null) {
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().setText(null);
                } else if (newValue instanceof String) {
                    if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getMode() == AutoCompleteTextField.Mode.TYPED_ONLY) {
                        throw new IllegalStateException("String '" + newValue + "' can not be used as value when working in checked mode");
                    }
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().setText((String)newValue);
                } else {
                    if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getMode() == AutoCompleteTextField.Mode.STRING_ONLY) {
                        throw new IllegalStateException("Only string values are supported");
                    }
                    String text = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataFormatter().toTextFieldString(newValue);
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().setText(text);
                }
                AutoCompleteTextFieldBehavior.this.updatingField = false;
            }
        }
    };
    private ChangeListener<String> textChangeListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            String refText;
            log.trace("textChangeListener updating to {}", (Object)newValue);
            if (AutoCompleteTextFieldBehavior.this.updatingField) {
                log.trace("textChangeListener updating field so return");
                return;
            }
            AutoCompleteTextFieldBehavior.this.text.set((Object)AutoCompleteTextFieldBehavior.this.skin.getTextField().getText());
            if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataProvider() != null) {
                AutoCompleteTextFieldBehavior.this.dataProviderTaskLauncher.stop();
                AutoCompleteTextFieldBehavior.this.dataProviderTaskLauncher.play();
            }
            oldValue = oldValue != null ? oldValue : "";
            String string = refText = newValue != null ? newValue.trim().toLowerCase() : "";
            if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataProvider() != null && newValue != null && oldValue.length() > 0 && newValue.startsWith(oldValue) && ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).isFilterItems()) {
                ArrayList toRemove = new ArrayList();
                AutoCompleteTextField.DataFormatter dataToString = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataFormatter();
                for (Object item : AutoCompleteTextFieldBehavior.this.autoCompleteList) {
                    String str = dataToString.toListViewString(item).toLowerCase();
                    if (StringUtils.startsWith((CharSequence)str, (CharSequence)refText)) continue;
                    toRemove.add(item);
                }
                AutoCompleteTextFieldBehavior.this.autoCompleteList.removeAll(toRemove);
            } else {
                AutoCompleteTextFieldBehavior.this.autoCompleteList.clear();
                if (refText.length() > 0) {
                    AutoCompleteTextFieldBehavior.this.extractMatchingItems(((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getItems(), refText);
                }
            }
            if (AutoCompleteTextFieldBehavior.this.autoCompleteList.size() > 0) {
                AutoCompleteTextFieldBehavior.this.skin.showPopup();
            } else {
                AutoCompleteTextFieldBehavior.this.skin.hidePopup();
            }
            AutoCompleteTextFieldBehavior.this.updatingField = true;
            if (((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getMode() != AutoCompleteTextField.Mode.TYPED_ONLY) {
                ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).setValue(newValue);
            } else {
                ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).setValue(null);
            }
            AutoCompleteTextFieldBehavior.this.updatingField = false;
        }
    };
    private final EventHandler<? super MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (event.getEventType() == MouseEvent.MOUSE_RELEASED && event.getSource() == AutoCompleteTextFieldBehavior.this.skin.getListView()) {
                AutoCompleteTextFieldBehavior.this.selectAutoCompleteItem();
            }
        }
    };
    private final EventHandler<? super KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (event.getEventType() == KeyEvent.KEY_PRESSED && event.getSource() == AutoCompleteTextFieldBehavior.this.skin.getTextField()) {
                KeyEvent t = event;
                if (t.getCode() == KeyCode.DOWN) {
                    if (!AutoCompleteTextFieldBehavior.this.skin.isPopupShowing()) {
                        String refText = Nvl.nvl((String)AutoCompleteTextFieldBehavior.this.skin.getTextField().getText()).trim().toLowerCase();
                        if (refText.isEmpty() && AutoCompleteTextFieldBehavior.this.autoCompleteList.isEmpty()) {
                            Object toAdd = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getItems();
                            int limit = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getLimit();
                            if (limit > 0) {
                                toAdd = toAdd.subList(0, limit);
                            }
                            AutoCompleteTextFieldBehavior.this.autoCompleteList.addAll(toAdd);
                            FXCollections.sort((ObservableList)AutoCompleteTextFieldBehavior.this.autoCompleteList, (Comparator)AutoCompleteTextFieldBehavior.this.listComparator);
                        }
                        AutoCompleteTextFieldBehavior.this.skin.showPopup();
                    } else {
                        AutoCompleteTextFieldBehavior.this.skin.getListView().requestFocus();
                        AutoCompleteTextFieldBehavior.this.skin.getListView().getSelectionModel().select(0);
                    }
                }
            } else if (event.getEventType() == KeyEvent.KEY_RELEASED && event.getSource() == AutoCompleteTextFieldBehavior.this.skin.getListView()) {
                KeyEvent t = event;
                switch (t.getCode()) {
                    case ENTER: {
                        AutoCompleteTextFieldBehavior.this.selectAutoCompleteItem();
                        break;
                    }
                    case UP: {
                        if (AutoCompleteTextFieldBehavior.this.skin.getListView().getSelectionModel().getSelectedIndex() != 0) break;
                        AutoCompleteTextFieldBehavior.this.skin.getTextField().requestFocus();
                        break;
                    }
                    case ESCAPE: {
                        AutoCompleteTextFieldBehavior.this.skin.getTextField().replaceText(AutoCompleteTextFieldBehavior.this.skin.getTextField().getSelection(), "");
                        AutoCompleteTextFieldBehavior.this.skin.getTextField().requestFocus();
                        AutoCompleteTextFieldBehavior.this.skin.hidePopup();
                        break;
                    }
                    case TAB: {
                        AutoCompleteTextFieldBehavior.this.skin.hidePopup();
                    }
                }
            }
        }
    };

    public AutoCompleteTextFieldBehavior(AutoCompleteTextField<T> control) {
        super(control, Collections.EMPTY_LIST);
    }

    public void initialize(final AutoCompleteTextFieldSkin<T> skin) {
        this.skin = skin;
        final AutoCompleteTextField control = (AutoCompleteTextField)this.getControl();
        ((StringProperty)control.textProperty()).bind((ObservableValue)this.text);
        this.text.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!StringUtils.isBlank((CharSequence)newValue)) {
                    ((StringProperty)control.lastTextProperty()).set((Object)newValue);
                }
            }
        });
        this.listComparator = new DataToStringComparator(control.getDataFormatter(), true);
        control.getItems().addListener(this.dataChangeListener);
        control.itemsProperty().addListener(new ChangeListener<ObservableList<T>>(){

            public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
                if (oldValue != null) {
                    oldValue.removeListener(AutoCompleteTextFieldBehavior.this.dataChangeListener);
                }
                if (newValue != null) {
                    newValue.addListener(AutoCompleteTextFieldBehavior.this.dataChangeListener);
                }
            }
        });
        control.modeProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue == AutoCompleteTextField.Mode.STRING_ONLY) {
                    AutoCompleteTextFieldBehavior.this.autoCompleteList.clear();
                }
            }
        });
        control.dataFormatterProperty().addListener(new ChangeListener<AutoCompleteTextField.DataFormatter<T>>(){

            public void changed(ObservableValue<? extends AutoCompleteTextField.DataFormatter<T>> observable, AutoCompleteTextField.DataFormatter<T> oldValue, AutoCompleteTextField.DataFormatter<T> newValue) {
                AutoCompleteTextFieldBehavior.this.listComparator = new DataToStringComparator(newValue, true);
                FXCollections.sort((ObservableList)AutoCompleteTextFieldBehavior.this.autoCompleteList, (Comparator)AutoCompleteTextFieldBehavior.this.listComparator);
            }
        });
        skin.getListView().setOnMouseReleased(this.mouseEventHandler);
        skin.getListView().setOnKeyReleased(this.keyEventHandler);
        skin.getListView().setItems(this.autoCompleteList);
        skin.getListView().getItems().addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> c) {
                if (!c.getList().isEmpty() && ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).isShowListOnData()) {
                    skin.showPopup();
                }
            }
        });
        skin.getTextField().setOnKeyPressed(this.keyEventHandler);
        skin.getTextField().textProperty().addListener(this.textChangeListener);
        skin.getTextField().focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && control.getMode() == AutoCompleteTextField.Mode.TYPED_ONLY && control.getValue() == null) {
                    skin.getTextField().setText("");
                }
            }
        });
        ((AutoCompleteTextField)this.getControl()).valueProperty().addListener(this.valueInvalidationListener);
        if (((AutoCompleteTextField)this.getControl()).getValue() != null) {
            this.valueInvalidationListener.invalidated((Observable)((AutoCompleteTextField)this.getControl()).valueProperty());
        }
        this.dataProviderTaskLauncher.getKeyFrames().add((Object)new KeyFrame(new Duration(500.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (AutoCompleteTextFieldBehavior.this.dataProviderTask != null) {
                    AutoCompleteTextFieldBehavior.this.dataProviderTask.cancel();
                }
                AutoCompleteTextFieldBehavior.this.dataProviderTask = new DataProviderTask(skin.getTextField().getText(), ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataProvider());
                AutoCompleteTextFieldBehavior.this.dataProviderTask.launch();
                ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).dataProcessingProperty().bind((ObservableValue)AutoCompleteTextFieldBehavior.this.dataProviderTask.runningProperty());
            }
        }, new KeyValue[0]));
        this.autoCompleteList.addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> c) {
                if (AutoCompleteTextFieldBehavior.this.autoCompleteList.size() == 1 && control.isSingleMatchSelection() && AutoCompleteTextFieldBehavior.this.dataProviderTask != null && AutoCompleteTextFieldBehavior.this.dataProviderTask.isDone()) {
                    AutoCompleteTextFieldBehavior.this.selectSingleMatchingItem();
                }
            }
        });
    }

    public void registerCellFocusInvalidationListener(final ListCell<T> cell) {
        InvalidationListener listener = new InvalidationListener(){

            public void invalidated(Observable ove) {
                if (cell.getItem() != null && cell.isFocused()) {
                    if (((String)AutoCompleteTextFieldBehavior.this.text.get()).length() <= 0 && AutoCompleteTextFieldBehavior.this.autoCompleteList.size() != ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getItems().size()) {
                        AutoCompleteTextFieldBehavior.this.text.set((Object)AutoCompleteTextFieldBehavior.this.skin.getTextField().getText());
                    }
                    String prev = (String)AutoCompleteTextFieldBehavior.this.text.get();
                    AutoCompleteTextFieldBehavior.this.updatingField = true;
                    String string = ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getDataFormatter().toTextFieldString(cell.getItem());
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().textProperty().setValue(string);
                    AutoCompleteTextFieldBehavior.this.updatingField = false;
                    AutoCompleteTextFieldBehavior.this.skin.getTextField().selectRange(prev.length(), string.length());
                    log.debug("{}={}::{}", new Object[]{((String)AutoCompleteTextFieldBehavior.this.text.get()).length(), AutoCompleteTextFieldBehavior.this.skin.getTextField().getText().length(), string.length()});
                }
            }
        };
        cell.focusedProperty().addListener(listener);
    }

    private void extractMatchingItems(List<? extends T> items, String text) {
        if (((AutoCompleteTextField)this.getControl()).isFilterItems()) {
            int itemsCount = this.autoCompleteList.size();
            int limit = ((AutoCompleteTextField)this.getControl()).getLimit();
            if (text.isEmpty()) {
                Object toAdd = ((AutoCompleteTextField)this.getControl()).getItems();
                if (limit > 0) {
                    toAdd = toAdd.subList(0, limit - itemsCount);
                }
                this.autoCompleteList.addAll(toAdd);
            } else {
                AutoCompleteTextField.DataFormatter dataToString = ((AutoCompleteTextField)this.getControl()).getDataFormatter();
                FullTextCriteria ftc = new FullTextCriteria(text, false, false);
                List itemsCopy = items.stream().map(e -> new PojoSearchWrapper<Object>(e, dataToString.toFilterString(e))).collect(Collectors.toList());
                PojoSearch.processList(itemsCopy, (FullTextCriteria)ftc, null, (boolean)true, null);
                if (((AutoCompleteTextField)this.getControl()).getLimit() > 0 && itemsCopy.size() > ((AutoCompleteTextField)this.getControl()).getLimit()) {
                    itemsCopy = itemsCopy.subList(0, ((AutoCompleteTextField)this.getControl()).getLimit());
                }
                List resulting = itemsCopy.stream().map(e -> ((PojoSearchWrapper)e).item).collect(Collectors.toList());
                this.autoCompleteList.setAll(resulting);
            }
        } else {
            this.autoCompleteList.setAll(items);
        }
    }

    private void selectAutoCompleteItem() {
        this.dataProviderTaskLauncher.stop();
        Object item = this.skin.getListView().getSelectionModel().getSelectedItem();
        this.skin.hidePopup();
        if (item == null) {
            return;
        }
        if (((AutoCompleteTextField)this.getControl()).getMode() != AutoCompleteTextField.Mode.STRING_ONLY) {
            ((AutoCompleteTextField)this.getControl()).setValue(item);
        } else {
            ((AutoCompleteTextField)this.getControl()).setValue(((AutoCompleteTextField)this.getControl()).getDataFormatter().toTextFieldString(item));
        }
        this.skin.getTextField().requestFocus();
        this.skin.getTextField().requestLayout();
        this.skin.getTextField().end();
        this.skin.hidePopup();
        this.updatingField = false;
        EventHandler<ActionEvent> onAction = ((AutoCompleteTextField)this.getControl()).getOnAction();
        if (onAction != null) {
            onAction.handle((Event)new ActionEvent(item, (EventTarget)this.getControl()));
        }
    }

    private void selectSingleMatchingItem() {
        this.dataProviderTaskLauncher.stop();
        Object item = this.autoCompleteList.get(0);
        if (item == null || ((AutoCompleteTextField)this.getControl()).getValue() == item) {
            return;
        }
        log.debug("getControl().getValue() == item {} ", (Object)(((AutoCompleteTextField)this.getControl()).getValue() == item ? 1 : 0));
        if (((AutoCompleteTextField)this.getControl()).getMode() != AutoCompleteTextField.Mode.STRING_ONLY) {
            ((AutoCompleteTextField)this.getControl()).setValue(item);
        } else {
            ((AutoCompleteTextField)this.getControl()).setValue(((AutoCompleteTextField)this.getControl()).getDataFormatter().toTextFieldString(item));
        }
        this.updatingField = false;
        EventHandler<ActionEvent> onAction = ((AutoCompleteTextField)this.getControl()).getOnAction();
        if (onAction != null) {
            onAction.handle((Event)new ActionEvent(item, (EventTarget)this.getControl()));
        }
        this.autoCompleteList.clear();
        ((AutoCompleteTextField)this.getControl()).getItems().clear();
    }

    private final class DataProviderTask
    extends ApplicationTask<List<T>> {
        private String text;
        private AutoCompleteTextField.DataProvider<T> dataProvider;

        public DataProviderTask(String text, AutoCompleteTextField.DataProvider<T> dataProvider) {
            this.text = text;
            this.dataProvider = dataProvider;
        }

        protected List<T> call() throws Exception {
            if (AutoCompleteTextFieldBehavior.this.dataProviderTask != this) {
                super.cancel();
                return null;
            }
            this.updateTitle(this.dataProvider.getTaskMessage(this.text));
            try {
                List ret = this.dataProvider.getData(this.text);
                log.debug("Got data {}", ret);
                return ret;
            }
            catch (Exception e) {
                log.warn("Exception looking up data in data provider", (Throwable)e);
                return null;
            }
        }

        protected void succeeded() {
            List ret = (List)super.getValue();
            if (this == AutoCompleteTextFieldBehavior.this.dataProviderTask || AutoCompleteTextFieldBehavior.this.dataProviderTask.isRunning()) {
                if (ret != null) {
                    ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getItems().setAll((Collection)ret);
                } else {
                    ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).getItems().clear();
                }
                if (!AutoCompleteTextFieldBehavior.this.autoCompleteList.isEmpty() && ((AutoCompleteTextField)AutoCompleteTextFieldBehavior.this.getControl()).textFieldFocusedProperty().get()) {
                    AutoCompleteTextFieldBehavior.this.skin.showPopup();
                } else {
                    AutoCompleteTextFieldBehavior.this.skin.hidePopup();
                }
            }
        }
    }

    private final class DataToStringComparator<T>
    implements Comparator<T> {
        private final AutoCompleteTextField.DataFormatter<T> dataToString;
        private final boolean ignoreCase;

        public DataToStringComparator(AutoCompleteTextField.DataFormatter<T> dataToString) {
            this(dataToString, true);
        }

        public DataToStringComparator(AutoCompleteTextField.DataFormatter<T> dataToString, boolean ignoreCase) {
            this.dataToString = dataToString;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.ignoreCase ? this.dataToString.toListViewString(o1).compareToIgnoreCase(this.dataToString.toListViewString(o2)) : this.dataToString.toListViewString(o1).compareTo(this.dataToString.toListViewString(o2));
        }
    }

    public static class PojoSearchWrapper<T> {
        @ExpandSearch(value=false)
        private T item;
        private String value;

        @ConstructorProperties(value={"item", "value"})
        public PojoSearchWrapper(T item, String value) {
            this.item = item;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

