/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.concurrent;

import com.anahata.jfx.concurrent.Background;
import com.anahata.jfx.concurrent.BackgroundDisable;
import com.anahata.jfx.concurrent.BackgroundInvocationHandler;
import com.anahata.jfx.concurrent.BackgroundRunning;
import com.anahata.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundProcessor {
    private static final Logger log = LoggerFactory.getLogger(BackgroundProcessor.class);

    public static void process(@NonNull Object controller, Node node) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        BackgroundProcessor.process(controller, node, new HashSet<Object>());
    }

    private static void process(@NonNull Object controller, Node node, Set<Object> processed) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        log.info("Processing {} default node to disable = {}", controller, (Object)node);
        try {
            Object o;
            List fields = ReflectionUtils.getAllDeclaredFields(controller.getClass());
            for (Field f : fields) {
                if (!f.isAnnotationPresent(Background.class)) continue;
                f.setAccessible(true);
                Object o2 = f.get(controller);
                if (!BackgroundInvocationHandler.isAsynchProxy(o2)) continue;
                log.warn("Field {} is already an asynch proxy, assuming controller has already been processed", (Object)f, controller);
                return;
            }
            Node n = node;
            SimpleBooleanProperty runningProperty = null;
            for (Field f : fields) {
                f.setAccessible(true);
                if (f.isAnnotationPresent(BackgroundRunning.class)) {
                    o = f.get(controller);
                    if (o == null) {
                        runningProperty = new SimpleBooleanProperty();
                        f.set(controller, runningProperty);
                    }
                    if (o instanceof BooleanProperty) {
                        runningProperty = (BooleanProperty)o;
                        continue;
                    }
                    throw new RuntimeException("Field " + controller.getClass().getSimpleName() + "." + f.getName() + " annotated as @BackgroundRunning but neither null or a BooleanProperty");
                }
                if (!f.isAnnotationPresent(BackgroundDisable.class)) continue;
                o = f.get(controller);
                if (o instanceof Node) {
                    n = (Node)o;
                    continue;
                }
                throw new RuntimeException("Field " + controller.getClass().getSimpleName() + "." + f.getName() + " annotated as @BackgroundDisable but not a node");
            }
            for (Field f : fields) {
                if (!f.isAnnotationPresent(Background.class)) continue;
                o = f.get(controller);
                log.info("Creating asynx proxy for {}.{} ", controller, (Object)f.getName());
                o = BackgroundInvocationHandler.newAsynchProxy(o, n, (BooleanProperty)runningProperty);
                f.set(controller, o);
            }
            processed.add(controller);
            for (Field f : fields) {
                if (!f.getName().endsWith("Controller")) continue;
                f.setAccessible(true);
                Object nestedController = f.get(controller);
                if (nestedController == null) continue;
                if (processed.contains(nestedController)) {
                    log.info("Nested controller already processed {}.{} = {}", new Object[]{controller, f.getName(), nestedController});
                    continue;
                }
                log.info("Processing child controller {}.{} = {}", new Object[]{controller, f.getName(), nestedController});
                BackgroundProcessor.process(nestedController, node, processed);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

